/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.updater;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.PluginSettings;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class UpdateChecker {
    public static final VersionScheme VERSION_SCHEME_DECIMAL = (string, string2) -> {
        String[] stringArray = UpdateChecker.splitVersionInfo(string);
        String[] stringArray2 = UpdateChecker.splitVersionInfo(string2);
        if (stringArray == null || stringArray2 == null) {
            return null;
        }
        for (int i = 0; i < Math.min(stringArray.length, stringArray2.length); ++i) {
            int n = UpdateChecker.toInt(stringArray[i], 0);
            int n2 = UpdateChecker.toInt(stringArray2[i], 0);
            if (n2 > n) {
                return string2;
            }
            if (n2 >= n) continue;
            return string;
        }
        return stringArray2.length > stringArray.length ? string2 : string;
    };
    private static final String USER_AGENT = "CHOCO-update-checker";
    private static final String UPDATE_URL = "https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=%d";
    private static final Pattern DECIMAL_SCHEME_PATTERN = Pattern.compile("\\d+(?:\\.\\d+)*");
    private static UpdateChecker instance;
    private UpdateResult lastResult = null;
    private final JavaPlugin plugin;
    private final int pluginID;
    private final VersionScheme versionScheme;

    private UpdateChecker(JavaPlugin javaPlugin, int n, VersionScheme versionScheme) {
        this.plugin = javaPlugin;
        this.pluginID = n;
        this.versionScheme = versionScheme;
    }

    public CompletableFuture<UpdateResult> requestUpdateCheck() {
        return CompletableFuture.supplyAsync(() -> {
            int n = -1;
            try {
                URL uRL = new URL(String.format(UPDATE_URL, this.pluginID));
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.addRequestProperty("User-Agent", USER_AGENT);
                InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
                n = httpURLConnection.getResponseCode();
                JsonElement jsonElement = new JsonParser().parse(inputStreamReader);
                inputStreamReader.close();
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String string = this.plugin.getDescription().getVersion();
                String string2 = jsonObject.get("current_version").getAsString();
                String string3 = this.versionScheme.compareVersions(string, string2);
                if (string3 == null) {
                    return new UpdateResult(UpdateReason.UNSUPPORTED_VERSION_SCHEME);
                }
                if (string3.equals(string)) {
                    return new UpdateResult(string.equals(string2) ? UpdateReason.UP_TO_DATE : UpdateReason.UNRELEASED_VERSION);
                }
                if (string3.equals(string2)) {
                    return new UpdateResult(UpdateReason.NEW_UPDATE, string3);
                }
            }
            catch (IOException iOException) {
                return new UpdateResult(UpdateReason.COULD_NOT_CONNECT);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                return new UpdateResult(UpdateReason.INVALID_JSON);
            }
            return new UpdateResult(n == 401 ? UpdateReason.UNAUTHORIZED_QUERY : UpdateReason.UNKNOWN_ERROR);
        });
    }

    public UpdateResult getLastResult() {
        return this.lastResult;
    }

    private static String[] splitVersionInfo(String string) {
        Matcher matcher = DECIMAL_SCHEME_PATTERN.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group().split("\\.");
    }

    public static UpdateChecker init(JavaPlugin javaPlugin, int n, VersionScheme versionScheme) {
        Preconditions.checkArgument((javaPlugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Plugin ID must be greater than 0");
        Preconditions.checkArgument((versionScheme != null ? 1 : 0) != 0, (Object)"null version schemes are unsupported");
        return instance == null ? (instance = new UpdateChecker(javaPlugin, n, versionScheme)) : instance;
    }

    public static UpdateChecker init(JavaPlugin javaPlugin, int n) {
        return UpdateChecker.init(javaPlugin, n, VERSION_SCHEME_DECIMAL);
    }

    public static UpdateChecker get() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance has not yet been initialized. Be sure #init() has been invoked");
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static int toInt(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static void runCheck(Guilds guilds, SettingsManager settingsManager) {
        if (settingsManager.getProperty(PluginSettings.UPDATE_CHECK).booleanValue()) {
            UpdateChecker.init(guilds, 66176).requestUpdateCheck().whenComplete((updateResult, throwable) -> {
                String string;
                if (updateResult.requiresUpdate()) {
                    guilds.getLogger().info(String.format("An update is available! Guilds %s may be downloaded on SpigotMC", updateResult.getNewestVersion()));
                    return;
                }
                switch (string = updateResult.getReason().toString()) {
                    case "UP_TO_DATE": {
                        guilds.getLogger().info(String.format("Your version of Guilds (%s) is up to date!", updateResult.getNewestVersion()));
                        break;
                    }
                    case "UNRELEASED_VERSION": {
                        guilds.getLogger().info(String.format("Your version of Guilds (%s) is more recent than the one publicly available. Are you on a development build?", updateResult.getNewestVersion()));
                        break;
                    }
                    default: {
                        guilds.getLogger().warning("Could not check for a new version of Guilds. Reason: " + string);
                    }
                }
            });
        }
    }

    public final class UpdateResult {
        private final UpdateReason reason;
        private final String newestVersion;

        private UpdateResult(UpdateReason updateReason, String string) {
            UpdateChecker.this.lastResult = this;
            this.reason = updateReason;
            this.newestVersion = string;
        }

        private UpdateResult(UpdateReason updateReason) {
            UpdateChecker.this.lastResult = this;
            Preconditions.checkArgument((updateReason != UpdateReason.NEW_UPDATE ? 1 : 0) != 0, (Object)"Reasons that require updates must also provide the latest version String");
            this.reason = updateReason;
            this.newestVersion = UpdateChecker.this.plugin.getDescription().getVersion();
        }

        public UpdateReason getReason() {
            return this.reason;
        }

        public boolean requiresUpdate() {
            return this.reason == UpdateReason.NEW_UPDATE;
        }

        public String getNewestVersion() {
            return this.newestVersion;
        }
    }

    @FunctionalInterface
    public static interface VersionScheme {
        public String compareVersions(String var1, String var2);
    }

    public static enum UpdateReason {
        NEW_UPDATE,
        COULD_NOT_CONNECT,
        INVALID_JSON,
        UNAUTHORIZED_QUERY,
        UNRELEASED_VERSION,
        UNKNOWN_ERROR,
        UNSUPPORTED_VERSION_SCHEME,
        UP_TO_DATE;

    }
}

