/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.utils;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.glaremasters.guilds.configuration.sections.ClaimSettings;
import me.glaremasters.guilds.configuration.sections.HooksSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.Unit;
import me.glaremasters.guilds.libs.kotlin.jvm.JvmStatic;
import me.glaremasters.guilds.libs.kotlin.jvm.functions.Function1;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Ref;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.SourceDebugExtension;
import me.glaremasters.guilds.libs.kotlin.text.StringsKt;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.codemc.worldguardwrapper.WorldGuardWrapper;
import org.codemc.worldguardwrapper.flag.IWrappedFlag;
import org.codemc.worldguardwrapper.flag.WrappedState;
import org.codemc.worldguardwrapper.region.IWrappedDomain;
import org.codemc.worldguardwrapper.region.IWrappedRegion;
import org.codemc.worldguardwrapper.selection.ICuboidSelection;
import org.codemc.worldguardwrapper.selection.ISelection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J(\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0007J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J(\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J&\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060.2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010/\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u00100\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020+H\u0007J(\u00101\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0007J(\u00102\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u00063"}, d2={"Lme/glaremasters/guilds/utils/ClaimUtils;", "", "()V", "addMember", "", "claim", "Lorg/codemc/worldguardwrapper/region/IWrappedRegion;", "player", "Lorg/bukkit/entity/Player;", "addMembers", "guild", "Lme/glaremasters/guilds/guild/Guild;", "addOwner", "checkAlreadyExist", "", "wrapper", "Lorg/codemc/worldguardwrapper/WorldGuardWrapper;", "name", "", "checkOverlap", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "checkPvpDisabled", "claimPointOne", "Lorg/bukkit/Location;", "claimPointTwo", "createClaim", "selection", "Lorg/codemc/worldguardwrapper/selection/ICuboidSelection;", "deleteWithGuild", "getClaim", "Ljava/util/Optional;", "getClaimName", "getGuildClaim", "getMembers", "Lorg/codemc/worldguardwrapper/region/IWrappedDomain;", "getRadius", "", "getSelection", "isEnabled", "isInDisabledWorld", "kickMember", "playerKicked", "Lorg/bukkit/OfflinePlayer;", "playerExecuting", "regions", "", "removeClaim", "removeMember", "setEnterMessage", "setExitMessage", "Guilds"})
@SourceDebugExtension(value={"SMAP\nClaimUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimUtils.kt\nme/glaremasters/guilds/utils/ClaimUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,440:1\n1855#2,2:441\n*S KotlinDebug\n*F\n+ 1 ClaimUtils.kt\nme/glaremasters/guilds/utils/ClaimUtils\n*L\n299#1:441,2\n*E\n"})
public final class ClaimUtils {
    @NotNull
    public static final ClaimUtils INSTANCE = new ClaimUtils();

    private ClaimUtils() {
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Boolean bl = settingsManager.getProperty(HooksSettings.WORLDGUARD);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"settingsManager.getPrope\u2026HooksSettings.WORLDGUARD)");
        return bl;
    }

    @JvmStatic
    public static final int getRadius(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Integer n = settingsManager.getProperty(ClaimSettings.RADIUS);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"settingsManager.getProperty(ClaimSettings.RADIUS)");
        return ((Number)n).intValue();
    }

    @JvmStatic
    @NotNull
    public static final Location claimPointOne(@NotNull Player player, @NotNull SettingsManager settingsManager) {
        double d;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        double d2 = ClaimUtils.getRadius(settingsManager);
        double d3 = player.getLocation().getX() - d2;
        try {
            d = player.getWorld().getMaxHeight();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            d = 0.0;
        }
        double d4 = d;
        d = player.getLocation().getZ() - d2;
        return new Location(player.getWorld(), d3, d4, d);
    }

    @JvmStatic
    @NotNull
    public static final Location claimPointTwo(@NotNull Player player, @NotNull SettingsManager settingsManager) {
        double d;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        double d2 = ClaimUtils.getRadius(settingsManager);
        double d3 = player.getLocation().getX() + d2;
        try {
            d = player.getWorld().getMinHeight();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            d = 0.0;
        }
        double d4 = d;
        d = player.getLocation().getZ() + d2;
        return new Location(player.getWorld(), d3, d4, d);
    }

    @JvmStatic
    @NotNull
    public static final String getClaimName(@NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        String string = guild.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guild.id.toString()");
        return string;
    }

    @JvmStatic
    public static final boolean checkAlreadyExist(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        for (World world : Bukkit.getWorlds()) {
            Optional<IWrappedRegion> optional = worldGuardWrapper.getRegion(world, ClaimUtils.getClaimName(guild));
            try {
                optional.get().getId();
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @JvmStatic
    public static final boolean checkAlreadyExist(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Player player, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        return worldGuardWrapper.getRegion(player.getWorld(), string).isPresent();
    }

    @JvmStatic
    @NotNull
    public static final Set<IWrappedRegion> regions(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Player player, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Set<IWrappedRegion> set = worldGuardWrapper.getRegions(ClaimUtils.claimPointOne(player, settingsManager), ClaimUtils.claimPointTwo(player, settingsManager));
        Intrinsics.checkNotNullExpressionValue(set, (String)"wrapper.getRegions(claim\u2026player, settingsManager))");
        return set;
    }

    @JvmStatic
    public static final boolean checkOverlap(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Player player, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        return !((Collection)ClaimUtils.regions(worldGuardWrapper, player, settingsManager)).isEmpty();
    }

    @JvmStatic
    public static final boolean isInDisabledWorld(@NotNull Player player, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        return settingsManager.getProperty(ClaimSettings.DISABLED_WORLDS).contains(player.getWorld().getName());
    }

    @JvmStatic
    public static final void createClaim(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Guild guild, @NotNull Player player, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        worldGuardWrapper.addCuboidRegion(ClaimUtils.getClaimName(guild), ClaimUtils.claimPointOne(player, settingsManager), ClaimUtils.claimPointTwo(player, settingsManager));
    }

    @JvmStatic
    public static final void createClaim(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Guild guild, @NotNull ICuboidSelection iCuboidSelection) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)iCuboidSelection, (String)"selection");
        worldGuardWrapper.addCuboidRegion(ClaimUtils.getClaimName(guild), iCuboidSelection.getMinimumPoint(), iCuboidSelection.getMaximumPoint());
    }

    @JvmStatic
    public static final void removeClaim(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        for (World world : Bukkit.getWorlds()) {
            worldGuardWrapper.removeRegion(world, ClaimUtils.getClaimName(guild));
        }
    }

    @JvmStatic
    @NotNull
    public static final Optional<IWrappedRegion> getGuildClaim(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Optional<IWrappedRegion> optional = worldGuardWrapper.getRegion(player.getWorld(), ClaimUtils.getClaimName(guild));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"wrapper.getRegion(player\u2026rld, getClaimName(guild))");
        return optional;
    }

    @JvmStatic
    @NotNull
    public static final Optional<IWrappedRegion> getClaim(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Player player, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        Optional<IWrappedRegion> optional = worldGuardWrapper.getRegion(player.getWorld(), string);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"wrapper.getRegion(player.world, name)");
        return optional;
    }

    @JvmStatic
    @NotNull
    public static final ICuboidSelection getSelection(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull Player player, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        ISelection iSelection = worldGuardWrapper.getRegion(player.getWorld(), string).get().getSelection();
        Intrinsics.checkNotNull((Object)iSelection, (String)"null cannot be cast to non-null type org.codemc.worldguardwrapper.selection.ICuboidSelection");
        return (ICuboidSelection)iSelection;
    }

    @JvmStatic
    public static final void addOwner(@NotNull IWrappedRegion iWrappedRegion, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        iWrappedRegion.getOwners().addPlayer(guild.getGuildMaster().getUuid());
    }

    @JvmStatic
    @NotNull
    public static final IWrappedDomain getMembers(@NotNull IWrappedRegion iWrappedRegion) {
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        IWrappedDomain iWrappedDomain = iWrappedRegion.getMembers();
        Intrinsics.checkNotNullExpressionValue((Object)iWrappedDomain, (String)"claim.members");
        return iWrappedDomain;
    }

    @JvmStatic
    public static final void addMembers(@NotNull IWrappedRegion iWrappedRegion, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        List<GuildMember> list2 = guild.getMembers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.members");
        Iterable iterable = list2;
        boolean bl = false;
        for (Object t : iterable) {
            GuildMember guildMember = (GuildMember)t;
            boolean bl2 = false;
            ClaimUtils.getMembers(iWrappedRegion).addPlayer(guildMember.getUuid());
        }
    }

    @JvmStatic
    public static final void addMember(@NotNull IWrappedRegion iWrappedRegion, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ClaimUtils.getMembers(iWrappedRegion).addPlayer(player.getUniqueId());
    }

    @JvmStatic
    public static final void removeMember(@NotNull IWrappedRegion iWrappedRegion, @NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        ClaimUtils.getMembers(iWrappedRegion).removePlayer(offlinePlayer.getUniqueId());
    }

    @JvmStatic
    public static final void kickMember(@NotNull OfflinePlayer offlinePlayer, @NotNull Player player, @NotNull Guild guild, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"playerKicked");
        Intrinsics.checkNotNullParameter((Object)player, (String)"playerExecuting");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        if (ClaimUtils.isEnabled(settingsManager)) {
            WorldGuardWrapper worldGuardWrapper = WorldGuardWrapper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)worldGuardWrapper, (String)"wrapper");
            ClaimUtils.getGuildClaim(worldGuardWrapper, player, guild).ifPresent(arg_0 -> ClaimUtils.kickMember$lambda$1((Function1)new Function1<IWrappedRegion, Unit>(offlinePlayer){
                final /* synthetic */ OfflinePlayer $playerKicked;
                {
                    this.$playerKicked = offlinePlayer;
                    super(1);
                }

                public final void invoke(@NotNull IWrappedRegion iWrappedRegion) {
                    Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"r");
                    ClaimUtils.removeMember(iWrappedRegion, this.$playerKicked);
                }
            }, arg_0));
        }
    }

    @JvmStatic
    public static final void setEnterMessage(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull IWrappedRegion iWrappedRegion, @NotNull SettingsManager settingsManager, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        IWrappedFlag iWrappedFlag = worldGuardWrapper.getFlag("greeting", String.class).orElse(null);
        String string = settingsManager.getProperty(ClaimSettings.ENTER_MESSAGE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsManager.getPrope\u2026imSettings.ENTER_MESSAGE)");
        String string2 = guild.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"guild.name");
        String string3 = StringsKt.replace$default((String)string, (String)"{guild}", (String)string2, (boolean)false, (int)4, null);
        String string4 = guild.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"guild.prefix");
        iWrappedRegion.setFlag(iWrappedFlag, StringUtils.color(StringsKt.replace$default((String)string3, (String)"{prefix}", (String)string4, (boolean)false, (int)4, null)));
    }

    @JvmStatic
    public static final void setExitMessage(@NotNull WorldGuardWrapper worldGuardWrapper, @NotNull IWrappedRegion iWrappedRegion, @NotNull SettingsManager settingsManager, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)worldGuardWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        IWrappedFlag iWrappedFlag = worldGuardWrapper.getFlag("farewell", String.class).orElse(null);
        String string = settingsManager.getProperty(ClaimSettings.EXIT_MESSAGE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsManager.getPrope\u2026aimSettings.EXIT_MESSAGE)");
        String string2 = guild.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"guild.name");
        String string3 = StringsKt.replace$default((String)string, (String)"{guild}", (String)string2, (boolean)false, (int)4, null);
        String string4 = guild.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"guild.prefix");
        iWrappedRegion.setFlag(iWrappedFlag, StringUtils.color(StringsKt.replace$default((String)string3, (String)"{prefix}", (String)string4, (boolean)false, (int)4, null)));
    }

    @JvmStatic
    public static final boolean checkPvpDisabled(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        WorldGuardWrapper worldGuardWrapper = WorldGuardWrapper.getInstance();
        Optional<IWrappedFlag<WrappedState>> optional = worldGuardWrapper.getFlag("pvp", WrappedState.class);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = WrappedState.ALLOW;
        if (!optional.isPresent()) {
            return false;
        }
        Optional<Optional> optional2 = optional.map(arg_0 -> ClaimUtils.checkPvpDisabled$lambda$2((Function1)new Function1<IWrappedFlag<WrappedState>, Optional<WrappedState>>(worldGuardWrapper, player){
            final /* synthetic */ WorldGuardWrapper $wrapper;
            final /* synthetic */ Player $player;
            {
                this.$wrapper = worldGuardWrapper;
                this.$player = player;
                super(1);
            }

            public final Optional<WrappedState> invoke(IWrappedFlag<WrappedState> iWrappedFlag) {
                return this.$wrapper.queryFlag(this.$player, this.$player.getLocation(), iWrappedFlag);
            }
        }, arg_0));
        optional2.ifPresent(arg_0 -> ClaimUtils.checkPvpDisabled$lambda$3((Function1)new Function1<Optional<WrappedState>, Unit>((Ref.ObjectRef<WrappedState>)objectRef){
            final /* synthetic */ Ref.ObjectRef<WrappedState> $state;
            {
                this.$state = objectRef;
                super(1);
            }

            public final void invoke(@NotNull Optional<WrappedState> optional) {
                WrappedState wrappedState;
                Ref.ObjectRef<WrappedState> objectRef;
                Intrinsics.checkNotNullParameter(optional, (String)"it");
                Ref.ObjectRef<WrappedState> objectRef2 = this.$state;
                try {
                    objectRef = objectRef2;
                    WrappedState wrappedState2 = optional.get();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)wrappedState2), (String)"{\n                it.get()\n            }");
                    wrappedState = wrappedState2;
                }
                catch (Exception exception) {
                    objectRef = objectRef2;
                    wrappedState = WrappedState.ALLOW;
                }
                objectRef.element = wrappedState;
            }
        }, arg_0));
        return objectRef.element == WrappedState.DENY;
    }

    @JvmStatic
    public static final void deleteWithGuild(@NotNull Guild guild, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        if (!ClaimUtils.isEnabled(settingsManager)) {
            return;
        }
        WorldGuardWrapper worldGuardWrapper = WorldGuardWrapper.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)worldGuardWrapper, (String)"wrapper");
        if (!ClaimUtils.checkAlreadyExist(worldGuardWrapper, guild)) {
            return;
        }
        ClaimUtils.removeClaim(worldGuardWrapper, guild);
    }

    private static final void kickMember$lambda$1(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final Optional checkPvpDisabled$lambda$2(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Optional)function1.invoke(object);
    }

    private static final void checkPvpDisabled$lambda$3(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }
}

