/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.utils;

import com.cryptomorin.xseries.SkullUtils;
import com.cryptomorin.xseries.XMaterial;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.utils.ItemBuilder;
import me.glaremasters.guilds.utils.LoggingUtils;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiUtils {
    public static final Set<Material> problemItems = new HashSet<Material>(Arrays.asList(XMaterial.REDSTONE_TORCH.parseMaterial(), XMaterial.RED_BED.parseMaterial()));

    public static ItemStack createItem(String string, String string2, List<String> list2) {
        Optional<XMaterial> optional = XMaterial.matchXMaterial(string);
        XMaterial xMaterial = optional.orElse(XMaterial.GLASS_PANE);
        ItemStack itemStack = xMaterial.parseItem();
        if (itemStack == null) {
            itemStack = XMaterial.GLASS_PANE.parseItem();
        }
        if (problemItems.contains(itemStack.getType())) {
            LoggingUtils.warn("Problematic Material Type Found! Switching to Barrier.");
            itemStack.setType(XMaterial.BARRIER.parseMaterial());
        }
        ItemBuilder itemBuilder = new ItemBuilder(itemStack);
        itemBuilder.setName(StringUtils.color(string2));
        if (!list2.isEmpty()) {
            itemBuilder.setLore(list2.stream().map(StringUtils::color).collect(Collectors.toList()));
        }
        itemBuilder.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
        return itemBuilder.build();
    }

    public static ItemStack createSkullItem(GuildMember guildMember, String string, List<String> list2) {
        ItemStack itemStack = SkullUtils.getSkull(guildMember.getUuid());
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(StringUtils.color(string));
        if (!list2.isEmpty()) {
            itemMeta.setLore(list2.stream().map(StringUtils::color).collect(Collectors.toList()));
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

