/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.utils;

import com.dumptruckman.bukkit.configuration.json.JsonConfiguration;
import java.util.HashMap;
import java.util.Map;
import me.glaremasters.guilds.configuration.sections.GuildVaultSettings;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Serialization {
    private Serialization() {
    }

    public static String serializeInventory(Inventory inventory) {
        return Serialization.serializeInventory(inventory.getSize(), inventory.getContents());
    }

    public static String serializeInventory(int n, ItemStack[] itemStackArray) {
        JsonConfiguration jsonConfiguration = new JsonConfiguration();
        jsonConfiguration.set("size", n);
        int n2 = 0;
        HashMap<String, ItemStack> hashMap = new HashMap<String, ItemStack>();
        for (ItemStack itemStack : itemStackArray) {
            int n3 = n2++;
            hashMap.put("" + n3, itemStack);
        }
        jsonConfiguration.createSection("items", hashMap);
        return jsonConfiguration.saveToString();
    }

    public static Inventory deserializeInventory(String string, SettingsManager settingsManager) {
        return Serialization.deserializeInventory(string, null, settingsManager);
    }

    public static Inventory deserializeInventory(String string, String string2, SettingsManager settingsManager) {
        try {
            JsonConfiguration jsonConfiguration = new JsonConfiguration();
            jsonConfiguration.loadFromString(string);
            int n = jsonConfiguration.getInt("size", 54);
            string2 = StringUtils.color(settingsManager.getProperty(GuildVaultSettings.VAULT_NAME));
            Inventory inventory = Bukkit.createInventory(null, (int)n, (String)string2);
            Map map = jsonConfiguration.getConfigurationSection("items").getValues(false);
            for (Map.Entry entry : map.entrySet()) {
                ItemStack itemStack = (ItemStack)entry.getValue();
                int n2 = Integer.parseInt((String)entry.getKey());
                inventory.setItem(n2, itemStack);
            }
            return inventory;
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            return null;
        }
    }
}

