/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArray
extends ArrayList<Object>
implements List<Object>,
JSONAwareEx,
JSONStreamAwareEx {
    private static final long serialVersionUID = 9106884089231309568L;

    public static String toJSONString(List<? extends Object> list2) {
        return JSONArray.toJSONString(list2, JSONValue.COMPRESSION);
    }

    public static String toJSONString(List<? extends Object> list2, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONArray.writeJSONString(list2, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static void writeJSONString(Iterable<? extends Object> iterable, Appendable appendable, JSONStyle jSONStyle) {
        if (iterable == null) {
            appendable.append("null");
            return;
        }
        boolean bl = true;
        appendable.append('[');
        for (Object object : iterable) {
            if (bl) {
                bl = false;
            } else {
                appendable.append(',');
            }
            if (object == null) {
                appendable.append("null");
                continue;
            }
            JSONValue.writeJSONString(object, appendable, jSONStyle);
        }
        appendable.append(']');
    }

    public static void writeJSONString(List<? extends Object> list2, Appendable appendable) {
        JSONArray.writeJSONString(list2, appendable, JSONValue.COMPRESSION);
    }

    public void merge(Object object) {
        JSONObject.merge(this, object);
    }

    @Override
    public String toJSONString() {
        return JSONArray.toJSONString(this, JSONValue.COMPRESSION);
    }

    @Override
    public String toJSONString(JSONStyle jSONStyle) {
        return JSONArray.toJSONString(this, jSONStyle);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public String toString(JSONStyle jSONStyle) {
        return this.toJSONString(jSONStyle);
    }

    @Override
    public void writeJSONString(Appendable appendable) {
        JSONArray.writeJSONString(this, appendable, JSONValue.COMPRESSION);
    }

    @Override
    public void writeJSONString(Appendable appendable, JSONStyle jSONStyle) {
        JSONArray.writeJSONString(this, appendable, jSONStyle);
    }
}

