/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ContentHandler;

public class ContentHandlerCompressor
implements ContentHandler {
    Appendable out;
    JSONStyle compression;
    int[] stack = new int[10];
    int pos;

    private void push(int n) {
        this.pos += 2;
        if (this.pos >= this.stack.length) {
            int[] nArray = new int[this.stack.length * 2];
            System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
            this.stack = nArray;
        }
        this.stack[this.pos] = n;
        this.stack[this.pos + 1] = 0;
    }

    private boolean isInObject() {
        return this.stack[this.pos] == 0;
    }

    private boolean isInArray() {
        return this.stack[this.pos] == 1;
    }

    public ContentHandlerCompressor(Appendable appendable, JSONStyle jSONStyle) {
        this.out = appendable;
        this.compression = jSONStyle;
    }

    public void startJSON() {
    }

    public void endJSON() {
    }

    public boolean startObject() {
        if (this.isInArray()) {
            int n = this.pos + 1;
            int n2 = this.stack[n];
            this.stack[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(',');
            }
        }
        this.out.append('{');
        this.push(0);
        return false;
    }

    public boolean endObject() {
        this.out.append('}');
        this.pos -= 2;
        return false;
    }

    public boolean startObjectEntry(String string) {
        int n = this.pos + 1;
        int n2 = this.stack[n];
        this.stack[n] = n2 + 1;
        if (n2 > 0) {
            this.out.append(',');
        }
        if (string == null) {
            this.out.append("null");
        } else if (!this.compression.mustProtectKey(string)) {
            this.out.append(string);
        } else {
            this.out.append('\"');
            JSONValue.escape(string, this.out, this.compression);
            this.out.append('\"');
        }
        this.out.append(':');
        return false;
    }

    public boolean endObjectEntry() {
        return false;
    }

    public boolean startArray() {
        if (this.isInArray()) {
            int n = this.pos + 1;
            int n2 = this.stack[n];
            this.stack[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(',');
            }
        }
        this.out.append('[');
        this.push(1);
        return false;
    }

    public boolean endArray() {
        this.out.append(']');
        this.pos -= 2;
        return false;
    }

    public boolean primitive(Object object) {
        if (!this.isInObject()) {
            int n = this.pos + 1;
            int n2 = this.stack[n];
            this.stack[n] = n2 + 1;
            if (n2 > 0) {
                this.out.append(',');
            }
        }
        if (object instanceof String) {
            if (!this.compression.mustProtectValue((String)object)) {
                this.out.append((String)object);
            } else {
                this.out.append('\"');
                JSONValue.escape((String)object, this.out, this.compression);
                this.out.append('\"');
            }
        } else {
            JSONValue.writeJSONString(object, this.out, this.compression);
        }
        return false;
    }
}

