/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.InputStream;
import java.io.Reader;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.JSONParserByteArray;
import net.minidev.json.parser.JSONParserInputStream;
import net.minidev.json.parser.JSONParserReader;
import net.minidev.json.parser.JSONParserString;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 400;
    public static final int MODE_JSON_SIMPLE = 448;
    public static final int MODE_STRICTEST = 144;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 448 : -1;
    private int mode;
    private JSONParserReader pStream;
    private JSONParserInputStream pSBintream;
    private JSONParserString pString;
    private JSONParserByteArray pBytes;

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int n) {
        this.mode = n;
    }

    public Object parse(String string) {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(string);
    }

    public Object parse(String string, ContainerFactory containerFactory) {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(string, containerFactory);
    }

    public Object parse(String string, ContainerFactory containerFactory, ContentHandler contentHandler) {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString.parse(string, containerFactory, contentHandler);
    }

    public Object parse(byte[] byArray) {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray);
    }

    public Object parse(byte[] byArray, ContainerFactory containerFactory) {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, containerFactory);
    }

    public Object parse(byte[] byArray, ContainerFactory containerFactory, ContentHandler contentHandler) {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes.parse(byArray, containerFactory, contentHandler);
    }

    public Object parse(Reader reader) {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(reader);
    }

    public Object parse(Reader reader, ContainerFactory containerFactory) {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(reader, containerFactory);
    }

    public Object parse(Reader reader, ContainerFactory containerFactory, ContentHandler contentHandler) {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream.parse(reader, containerFactory);
    }

    public Object parse(InputStream inputStream) {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(inputStream);
    }

    public Object parse(InputStream inputStream, ContainerFactory containerFactory) {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(inputStream, containerFactory);
    }

    public Object parse(InputStream inputStream, ContainerFactory containerFactory, ContentHandler contentHandler) {
        if (this.pSBintream == null) {
            this.pSBintream = new JSONParserInputStream(this.mode);
        }
        return this.pSBintream.parse(inputStream, containerFactory);
    }
}

