/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JSONParserBase {
    protected char c;
    public static final byte EOI = 26;
    protected static final char MAX_STOP = '~';
    protected static boolean[] stopAll = new boolean[126];
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    protected ContainerFactory containerFactory;
    protected ContentHandler handler;
    protected final MSB sb = new MSB(15);
    protected Object xo;
    protected String xs;
    protected int pos;
    protected final boolean acceptLeadinZero;
    protected final boolean acceptNaN;
    protected final boolean acceptNonQuote;
    protected final boolean acceptSimpleQuote;
    protected final boolean acceptUselessComma;
    protected final boolean checkTaillingData;
    protected final boolean ignoreControlChar;
    protected final boolean useHiPrecisionFloat;
    protected final boolean useIntegerStorage;

    public JSONParserBase(int n) {
        this.acceptNaN = (n & 4) > 0;
        this.acceptNonQuote = (n & 2) > 0;
        this.acceptSimpleQuote = (n & 1) > 0;
        this.ignoreControlChar = (n & 8) > 0;
        this.useIntegerStorage = (n & 0x10) > 0;
        this.acceptLeadinZero = (n & 0x20) > 0;
        this.acceptUselessComma = (n & 0x40) > 0;
        this.useHiPrecisionFloat = (n & 0x80) > 0;
        this.checkTaillingData = (n & 0x100) == 0;
    }

    public void checkControleChar() {
        if (this.ignoreControlChar) {
            return;
        }
        int n = this.xs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.xs.charAt(i);
            if (c < '\u0000') continue;
            if (c <= '\u001f') {
                throw new ParseException(this.pos + i, 0, Character.valueOf(c));
            }
            if (c != '\u007f') continue;
            throw new ParseException(this.pos + i, 0, Character.valueOf(c));
        }
    }

    public void checkLeadinZero() {
        int n = this.xs.length();
        if (n == 1) {
            return;
        }
        if (n == 2) {
            if (this.xs.equals("00")) {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        char c = this.xs.charAt(0);
        char c2 = this.xs.charAt(1);
        if (c == '-') {
            char c3 = this.xs.charAt(2);
            if (c2 == '0' && c3 >= '0' && c3 <= '9') {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        if (c == '0' && c2 >= '0' && c2 <= '9') {
            throw new ParseException(this.pos, 6, this.xs);
        }
    }

    protected Number extractFloat() {
        if (!this.acceptLeadinZero) {
            this.checkLeadinZero();
        }
        if (!this.useHiPrecisionFloat) {
            return Float.valueOf(Float.parseFloat(this.xs));
        }
        if (this.xs.length() > 18) {
            return new BigDecimal(this.xs);
        }
        return Double.parseDouble(this.xs);
    }

    public Object parse(ContainerFactory containerFactory, ContentHandler contentHandler) {
        Object object;
        this.containerFactory = containerFactory;
        this.handler = contentHandler;
        this.pos = -1;
        try {
            this.read();
            contentHandler.startJSON();
            object = this.readMain(stopX);
            contentHandler.endJSON();
            if (this.checkTaillingData) {
                this.skipSpace();
                if (this.c != '\u001a') {
                    throw new ParseException(this.pos - 1, 1, Character.valueOf(this.c));
                }
            }
        }
        catch (IOException iOException) {
            throw new ParseException(this.pos, (Throwable)iOException);
        }
        this.xs = null;
        this.xo = null;
        return object;
    }

    protected Number parseNumber(String string) {
        boolean bl;
        boolean bl2;
        int n = 0;
        int n2 = string.length();
        int n3 = 19;
        if (string.charAt(0) == '-') {
            ++n;
            ++n3;
            bl2 = true;
            if (!this.acceptLeadinZero && n2 >= 3 && string.charAt(1) == '0') {
                throw new ParseException(this.pos, 6, string);
            }
        } else {
            bl2 = false;
            if (!this.acceptLeadinZero && n2 >= 2 && string.charAt(0) == '0') {
                throw new ParseException(this.pos, 6, string);
            }
        }
        if (n2 < n3) {
            n3 = n2;
            bl = false;
        } else {
            if (n2 > n3) {
                return new BigInteger(string, 10);
            }
            n3 = n2 - 1;
            bl = true;
        }
        long l = 0L;
        while (n < n3) {
            l = l * 10L + (long)(48 - string.charAt(n++));
        }
        if (bl) {
            boolean bl3;
            if (l > -922337203685477580L) {
                bl3 = false;
            } else if (l < -922337203685477580L) {
                bl3 = true;
            } else if (bl2) {
                bl3 = string.charAt(n) > '8';
            } else {
                boolean bl4 = bl3 = string.charAt(n) > '7';
            }
            if (bl3) {
                return new BigInteger(string, 10);
            }
            l = l * 10L + (long)(48 - string.charAt(n));
        }
        if (bl2) {
            if (this.useIntegerStorage && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
            return l;
        }
        l = -l;
        if (this.useIntegerStorage && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return l;
    }

    protected abstract void read();

    protected List<Object> readArray() {
        List<Object> list2 = this.containerFactory.createArrayContainer();
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        boolean bl = false;
        this.handler.startArray();
        block7: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block7;
                }
                case ']': {
                    if (bl && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    this.handler.endArray();
                    return list2;
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case ',': {
                    if (bl && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    bl = true;
                    continue block7;
                }
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            list2.add(this.readMain(stopArray));
            bl = false;
        }
    }

    protected Object readMain(boolean[] blArray) {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case '\"': 
                case '\'': {
                    this.readString();
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'n': {
                    this.readNQString(blArray);
                    if ("null".equals(this.xs)) {
                        this.handler.primitive(null);
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'f': {
                    this.readNQString(blArray);
                    if ("false".equals(this.xs)) {
                        this.handler.primitive(Boolean.FALSE);
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 't': {
                    this.readNQString(blArray);
                    if ("true".equals(this.xs)) {
                        this.handler.primitive(Boolean.TRUE);
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 'N': {
                    this.readNQString(blArray);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        this.handler.primitive(Float.valueOf(Float.NaN));
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.xo = this.readNumber(blArray);
                    this.handler.primitive(this.xo);
                    return this.xo;
                }
            }
            break;
        }
        this.readNQString(blArray);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        this.handler.primitive(this.xs);
        return this.xs;
    }

    protected abstract void readNoEnd();

    protected abstract void readNQString(boolean[] var1);

    protected abstract Object readNumber(boolean[] var1);

    protected Map<String, Object> readObject() {
        Map<String, Object> map = this.containerFactory.createObjectContainer();
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        this.handler.startObject();
        boolean bl = false;
        boolean bl2 = true;
        block6: while (true) {
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '}': {
                    if (bl && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    this.handler.endObject();
                    return map;
                }
                case ',': {
                    if (bl && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    bl = true;
                    bl2 = true;
                    continue block6;
                }
            }
            int n = this.pos;
            if (this.c == '\"' || this.c == '\'') {
                this.readString();
            } else {
                this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
            }
            String string = this.xs;
            if (!bl2) {
                throw new ParseException(this.pos, 1, string);
            }
            this.handler.startObjectEntry(string);
            while (this.c != ':' && this.c != '\u001a') {
                this.read();
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            this.readNoEnd();
            Object object = map.put(string, this.readMain(stopValue));
            if (object != null) {
                throw new ParseException(n, 5, string);
            }
            this.handler.endObjectEntry();
            if (this.c == '}') {
                this.read();
                this.handler.endObject();
                return map;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            if (this.c == ',') {
                bl = true;
                bl2 = true;
                continue;
            }
            bl = false;
            bl2 = false;
        }
    }

    abstract void readS();

    protected abstract void readString();

    protected void readString2() {
        char c = this.c;
        block18: while (true) {
            this.read();
            switch (this.c) {
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case '\"': 
                case '\'': {
                    if (c == this.c) {
                        this.read();
                        this.xs = this.sb.toString();
                        return;
                    }
                    this.sb.append(this.c);
                    continue block18;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            continue block18;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            continue block18;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            continue block18;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            continue block18;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            continue block18;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            continue block18;
                        }
                        case '/': {
                            this.sb.append('/');
                            continue block18;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            continue block18;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            continue block18;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode());
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    if (this.ignoreControlChar) continue block18;
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
            }
            this.sb.append(this.c);
        }
    }

    protected char readUnicode() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n *= 16;
            this.read();
            if (this.c <= '9' && this.c >= '0') {
                n += this.c - 48;
                continue;
            }
            if (this.c <= 'F' && this.c >= 'A') {
                n += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                n += this.c - 97 + 10;
                continue;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, Character.valueOf(this.c));
        }
        return (char)n;
    }

    protected void skipDigits() {
        while (this.c >= '0' && this.c <= '9') {
            this.readS();
        }
        return;
    }

    protected void skipNQString(boolean[] blArray) {
        while (!(this.c == '\u001a' || this.c >= '\u0000' && this.c < '~' && blArray[this.c])) {
            this.readS();
        }
        return;
    }

    protected void skipSpace() {
        while (this.c <= ' ' && this.c != '\u001a') {
            this.readS();
        }
        return;
    }

    static {
        JSONParserBase.stopKey[26] = true;
        JSONParserBase.stopKey[58] = true;
        JSONParserBase.stopValue[26] = true;
        JSONParserBase.stopValue[125] = true;
        JSONParserBase.stopValue[44] = true;
        JSONParserBase.stopArray[26] = true;
        JSONParserBase.stopArray[93] = true;
        JSONParserBase.stopArray[44] = true;
        JSONParserBase.stopX[26] = true;
        JSONParserBase.stopAll[58] = true;
        JSONParserBase.stopAll[44] = true;
        JSONParserBase.stopAll[26] = true;
        JSONParserBase.stopAll[125] = true;
        JSONParserBase.stopAll[93] = true;
    }

    public static class MSB {
        char[] b;
        int p;

        public MSB(int n) {
            this.b = new char[n];
            this.p = -1;
        }

        public void append(char c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] cArray = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, cArray, 0, this.b.length);
                this.b = cArray;
            }
            this.b[this.p] = c;
        }

        public void append(int n) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] cArray = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, cArray, 0, this.b.length);
                this.b = cArray;
            }
            this.b[this.p] = (char)n;
        }

        public String toString() {
            return new String(this.b, 0, this.p + 1);
        }

        public void clear() {
            this.p = -1;
        }
    }
}

