/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.nio.charset.StandardCharsets;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.misc.Interval;

public abstract class CodePointCharStream
implements CharStream {
    protected final int size;
    protected final String name;
    protected int position;

    private CodePointCharStream(int n, int n2, String string) {
        assert (n == 0);
        this.size = n2;
        this.name = string;
        this.position = 0;
    }

    abstract Object getInternalStorage();

    public static CodePointCharStream fromBuffer(CodePointBuffer codePointBuffer) {
        return CodePointCharStream.fromBuffer(codePointBuffer, "<unknown>");
    }

    public static CodePointCharStream fromBuffer(CodePointBuffer codePointBuffer, String string) {
        switch (codePointBuffer.getType()) {
            case BYTE: {
                return new CodePoint8BitCharStream(codePointBuffer.position(), codePointBuffer.remaining(), string, codePointBuffer.byteArray(), codePointBuffer.arrayOffset());
            }
            case CHAR: {
                return new CodePoint16BitCharStream(codePointBuffer.position(), codePointBuffer.remaining(), string, codePointBuffer.charArray(), codePointBuffer.arrayOffset());
            }
            case INT: {
                return new CodePoint32BitCharStream(codePointBuffer.position(), codePointBuffer.remaining(), string, codePointBuffer.intArray(), codePointBuffer.arrayOffset());
            }
        }
        throw new UnsupportedOperationException("Not reached");
    }

    @Override
    public final void consume() {
        if (this.size - this.position == 0) {
            assert (this.LA(1) == -1);
            throw new IllegalStateException("cannot consume EOF");
        }
        ++this.position;
    }

    @Override
    public final int index() {
        return this.position;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final int mark() {
        return -1;
    }

    @Override
    public final void release(int n) {
    }

    @Override
    public final void seek(int n) {
        this.position = n;
    }

    @Override
    public final String getSourceName() {
        if (this.name == null || this.name.isEmpty()) {
            return "<unknown>";
        }
        return this.name;
    }

    public final String toString() {
        return this.getText(Interval.of(0, this.size - 1));
    }

    private static final class CodePoint32BitCharStream
    extends CodePointCharStream {
        private final int[] intArray;

        private CodePoint32BitCharStream(int n, int n2, String string, int[] nArray, int n3) {
            super(n, n2, string);
            this.intArray = nArray;
            assert (n3 == 0);
        }

        @Override
        public String getText(Interval interval) {
            int n = Math.min(interval.a, this.size);
            int n2 = Math.min(interval.b - interval.a + 1, this.size - n);
            return new String(this.intArray, n, n2);
        }

        @Override
        public int LA(int n) {
            switch (Integer.signum(n)) {
                case -1: {
                    int n2 = this.position + n;
                    if (n2 < 0) {
                        return -1;
                    }
                    return this.intArray[n2];
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    int n3 = this.position + n - 1;
                    if (n3 >= this.size) {
                        return -1;
                    }
                    return this.intArray[n3];
                }
            }
            throw new UnsupportedOperationException("Not reached");
        }

        @Override
        Object getInternalStorage() {
            return this.intArray;
        }
    }

    private static final class CodePoint16BitCharStream
    extends CodePointCharStream {
        private final char[] charArray;

        private CodePoint16BitCharStream(int n, int n2, String string, char[] cArray, int n3) {
            super(n, n2, string);
            this.charArray = cArray;
            assert (n3 == 0);
        }

        @Override
        public String getText(Interval interval) {
            int n = Math.min(interval.a, this.size);
            int n2 = Math.min(interval.b - interval.a + 1, this.size - n);
            return new String(this.charArray, n, n2);
        }

        @Override
        public int LA(int n) {
            switch (Integer.signum(n)) {
                case -1: {
                    int n2 = this.position + n;
                    if (n2 < 0) {
                        return -1;
                    }
                    return this.charArray[n2] & 0xFFFF;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    int n3 = this.position + n - 1;
                    if (n3 >= this.size) {
                        return -1;
                    }
                    return this.charArray[n3] & 0xFFFF;
                }
            }
            throw new UnsupportedOperationException("Not reached");
        }

        @Override
        Object getInternalStorage() {
            return this.charArray;
        }
    }

    private static final class CodePoint8BitCharStream
    extends CodePointCharStream {
        private final byte[] byteArray;

        private CodePoint8BitCharStream(int n, int n2, String string, byte[] byArray, int n3) {
            super(n, n2, string);
            assert (n3 == 0);
            this.byteArray = byArray;
        }

        @Override
        public String getText(Interval interval) {
            int n = Math.min(interval.a, this.size);
            int n2 = Math.min(interval.b - interval.a + 1, this.size - n);
            return new String(this.byteArray, n, n2, StandardCharsets.ISO_8859_1);
        }

        @Override
        public int LA(int n) {
            switch (Integer.signum(n)) {
                case -1: {
                    int n2 = this.position + n;
                    if (n2 < 0) {
                        return -1;
                    }
                    return this.byteArray[n2] & 0xFF;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    int n3 = this.position + n - 1;
                    if (n3 >= this.size) {
                        return -1;
                    }
                    return this.byteArray[n3] & 0xFF;
                }
            }
            throw new UnsupportedOperationException("Not reached");
        }

        @Override
        Object getInternalStorage() {
            return this.byteArray;
        }
    }
}

