/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.Pair;

public class ListTokenSource
implements TokenSource {
    protected final List<? extends Token> tokens;
    private final String sourceName;
    protected int i;
    protected Token eofToken;
    private TokenFactory<?> _factory = CommonTokenFactory.DEFAULT;

    public ListTokenSource(List<? extends Token> list2) {
        this(list2, null);
    }

    public ListTokenSource(List<? extends Token> list2, String string) {
        if (list2 == null) {
            throw new NullPointerException("tokens cannot be null");
        }
        this.tokens = list2;
        this.sourceName = string;
    }

    @Override
    public int getCharPositionInLine() {
        if (this.i < this.tokens.size()) {
            return this.tokens.get(this.i).getCharPositionInLine();
        }
        if (this.eofToken != null) {
            return this.eofToken.getCharPositionInLine();
        }
        if (this.tokens.size() > 0) {
            int n;
            Token token = this.tokens.get(this.tokens.size() - 1);
            String string = token.getText();
            if (string != null && (n = string.lastIndexOf(10)) >= 0) {
                return string.length() - n - 1;
            }
            return token.getCharPositionInLine() + token.getStopIndex() - token.getStartIndex() + 1;
        }
        return 0;
    }

    @Override
    public Token nextToken() {
        if (this.i >= this.tokens.size()) {
            if (this.eofToken == null) {
                int n;
                int n2 = -1;
                if (this.tokens.size() > 0 && (n = this.tokens.get(this.tokens.size() - 1).getStopIndex()) != -1) {
                    n2 = n + 1;
                }
                n = Math.max(-1, n2 - 1);
                this.eofToken = this._factory.create(new Pair<TokenSource, CharStream>(this, this.getInputStream()), -1, "EOF", 0, n2, n, this.getLine(), this.getCharPositionInLine());
            }
            return this.eofToken;
        }
        Token token = this.tokens.get(this.i);
        if (this.i == this.tokens.size() - 1 && token.getType() == -1) {
            this.eofToken = token;
        }
        ++this.i;
        return token;
    }

    @Override
    public int getLine() {
        if (this.i < this.tokens.size()) {
            return this.tokens.get(this.i).getLine();
        }
        if (this.eofToken != null) {
            return this.eofToken.getLine();
        }
        if (this.tokens.size() > 0) {
            Token token = this.tokens.get(this.tokens.size() - 1);
            int n = token.getLine();
            String string = token.getText();
            if (string != null) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '\n') continue;
                    ++n;
                }
            }
            return n;
        }
        return 1;
    }

    @Override
    public CharStream getInputStream() {
        if (this.i < this.tokens.size()) {
            return this.tokens.get(this.i).getInputStream();
        }
        if (this.eofToken != null) {
            return this.eofToken.getInputStream();
        }
        if (this.tokens.size() > 0) {
            return this.tokens.get(this.tokens.size() - 1).getInputStream();
        }
        return null;
    }

    @Override
    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        CharStream charStream = this.getInputStream();
        if (charStream != null) {
            return charStream.getSourceName();
        }
        return "List";
    }

    @Override
    public void setTokenFactory(TokenFactory<?> tokenFactory) {
        this._factory = tokenFactory;
    }

    @Override
    public TokenFactory<?> getTokenFactory() {
        return this._factory;
    }
}

