/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class IntegerList {
    private static int[] EMPTY_DATA = new int[0];
    private static final int INITIAL_SIZE = 4;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private int[] _data;
    private int _size;

    public IntegerList() {
        this._data = EMPTY_DATA;
    }

    public IntegerList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._data = n == 0 ? EMPTY_DATA : new int[n];
    }

    public IntegerList(IntegerList integerList) {
        this._data = (int[])integerList._data.clone();
        this._size = integerList._size;
    }

    public IntegerList(Collection<Integer> collection) {
        this(collection.size());
        for (Integer n : collection) {
            this.add(n);
        }
    }

    public final void add(int n) {
        if (this._data.length == this._size) {
            this.ensureCapacity(this._size + 1);
        }
        this._data[this._size] = n;
        ++this._size;
    }

    public final void addAll(int[] nArray) {
        this.ensureCapacity(this._size + nArray.length);
        System.arraycopy(nArray, 0, this._data, this._size, nArray.length);
        this._size += nArray.length;
    }

    public final void addAll(IntegerList integerList) {
        this.ensureCapacity(this._size + integerList._size);
        System.arraycopy(integerList._data, 0, this._data, this._size, integerList._size);
        this._size += integerList._size;
    }

    public final void addAll(Collection<Integer> collection) {
        this.ensureCapacity(this._size + collection.size());
        int n = 0;
        Iterator<Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n2;
            this._data[this._size + n] = n2 = iterator.next().intValue();
            ++n;
        }
        this._size += collection.size();
    }

    public final int get(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        return this._data[n];
    }

    public final boolean contains(int n) {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] != n) continue;
            return true;
        }
        return false;
    }

    public final int set(int n, int n2) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    public final int removeAt(int n) {
        int n2 = this.get(n);
        System.arraycopy(this._data, n + 1, this._data, n, this._size - n - 1);
        this._data[this._size - 1] = 0;
        --this._size;
        return n2;
    }

    public final void removeRange(int n, int n2) {
        if (n < 0 || n2 < 0 || n > this._size || n2 > this._size) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this._data, n2, this._data, n, this._size - n2);
        Arrays.fill(this._data, this._size - (n2 - n), this._size, 0);
        this._size -= n2 - n;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final int size() {
        return this._size;
    }

    public final void trimToSize() {
        if (this._data.length == this._size) {
            return;
        }
        this._data = Arrays.copyOf(this._data, this._size);
    }

    public final void clear() {
        Arrays.fill(this._data, 0, this._size, 0);
        this._size = 0;
    }

    public final int[] toArray() {
        if (this._size == 0) {
            return EMPTY_DATA;
        }
        return Arrays.copyOf(this._data, this._size);
    }

    public final void sort() {
        Arrays.sort(this._data, 0, this._size);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegerList)) {
            return false;
        }
        IntegerList integerList = (IntegerList)object;
        if (this._size != integerList._size) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == integerList._data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this._size; ++i) {
            n = 31 * n + this._data[i];
        }
        return n;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public final int binarySearch(int n) {
        return Arrays.binarySearch(this._data, 0, this._size, n);
    }

    public final int binarySearch(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n > this._size || n2 > this._size) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        return Arrays.binarySearch(this._data, n, n2, n3);
    }

    private void ensureCapacity(int n) {
        if (n < 0 || n > 0x7FFFFFF7) {
            throw new OutOfMemoryError();
        }
        int n2 = this._data.length == 0 ? 4 : this._data.length;
        while (n2 < n) {
            if ((n2 *= 2) >= 0 && n2 <= 0x7FFFFFF7) continue;
            n2 = 0x7FFFFFF7;
        }
        this._data = Arrays.copyOf(this._data, n2);
    }

    public final char[] toCharArray() {
        char[] cArray = new char[this._size];
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this._size; ++i) {
            int n2 = this._data[i];
            if (!bl && Character.isSupplementaryCodePoint(n2)) {
                cArray = Arrays.copyOf(cArray, this.charArraySize());
                bl = true;
            }
            int n3 = Character.toChars(n2, cArray, n);
            n += n3;
        }
        return cArray;
    }

    private int charArraySize() {
        int n = 0;
        for (int i = 0; i < this._size; ++i) {
            n += Character.charCount(this._data[i]);
        }
        return n;
    }
}

