/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.Predicate;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.antlr.v4.runtime.tree.Tree;

public class Trees {
    public static String toStringTree(Tree tree) {
        return Trees.toStringTree(tree, (List<String>)null);
    }

    public static String toStringTree(Tree tree, Parser parser) {
        String[] stringArray = parser != null ? parser.getRuleNames() : null;
        List<String> list2 = stringArray != null ? Arrays.asList(stringArray) : null;
        return Trees.toStringTree(tree, list2);
    }

    public static String toStringTree(Tree tree, List<String> list2) {
        String string = Utils.escapeWhitespace(Trees.getNodeText(tree, list2), false);
        if (tree.getChildCount() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        string = Utils.escapeWhitespace(Trees.getNodeText(tree, list2), false);
        stringBuilder.append(string);
        stringBuilder.append(' ');
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Trees.toStringTree(tree.getChild(i), list2));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getNodeText(Tree tree, Parser parser) {
        String[] stringArray = parser != null ? parser.getRuleNames() : null;
        List<String> list2 = stringArray != null ? Arrays.asList(stringArray) : null;
        return Trees.getNodeText(tree, list2);
    }

    public static String getNodeText(Tree tree, List<String> list2) {
        Object object;
        if (list2 != null) {
            if (tree instanceof RuleContext) {
                int n = ((RuleContext)tree).getRuleContext().getRuleIndex();
                String string = list2.get(n);
                int n2 = ((RuleContext)tree).getAltNumber();
                if (n2 != 0) {
                    return string + ":" + n2;
                }
                return string;
            }
            if (tree instanceof ErrorNode) {
                return tree.toString();
            }
            if (tree instanceof TerminalNode && (object = ((TerminalNode)tree).getSymbol()) != null) {
                String string = object.getText();
                return string;
            }
        }
        if ((object = tree.getPayload()) instanceof Token) {
            return ((Token)object).getText();
        }
        return tree.getPayload().toString();
    }

    public static List<Tree> getChildren(Tree tree) {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            arrayList.add(tree.getChild(i));
        }
        return arrayList;
    }

    public static List<? extends Tree> getAncestors(Tree tree) {
        if (tree.getParent() == null) {
            return Collections.emptyList();
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (tree = tree.getParent(); tree != null; tree = tree.getParent()) {
            arrayList.add(0, tree);
        }
        return arrayList;
    }

    public static boolean isAncestorOf(Tree tree, Tree tree2) {
        if (tree == null || tree2 == null || tree.getParent() == null) {
            return false;
        }
        for (Tree tree3 = tree2.getParent(); tree3 != null; tree3 = tree3.getParent()) {
            if (tree != tree3) continue;
            return true;
        }
        return false;
    }

    public static Collection<ParseTree> findAllTokenNodes(ParseTree parseTree, int n) {
        return Trees.findAllNodes(parseTree, n, true);
    }

    public static Collection<ParseTree> findAllRuleNodes(ParseTree parseTree, int n) {
        return Trees.findAllNodes(parseTree, n, false);
    }

    public static List<ParseTree> findAllNodes(ParseTree parseTree, int n, boolean bl) {
        ArrayList<ParseTree> arrayList = new ArrayList<ParseTree>();
        Trees._findAllNodes(parseTree, n, bl, arrayList);
        return arrayList;
    }

    public static void _findAllNodes(ParseTree parseTree, int n, boolean bl, List<? super ParseTree> list2) {
        ParseTree parseTree2;
        if (bl && parseTree instanceof TerminalNode) {
            parseTree2 = (TerminalNode)parseTree;
            if (parseTree2.getSymbol().getType() == n) {
                list2.add(parseTree);
            }
        } else if (!bl && parseTree instanceof ParserRuleContext && ((RuleContext)(parseTree2 = (ParserRuleContext)parseTree)).getRuleIndex() == n) {
            list2.add(parseTree);
        }
        for (int i = 0; i < parseTree.getChildCount(); ++i) {
            Trees._findAllNodes(parseTree.getChild(i), n, bl, list2);
        }
    }

    public static List<ParseTree> getDescendants(ParseTree parseTree) {
        ArrayList<ParseTree> arrayList = new ArrayList<ParseTree>();
        arrayList.add(parseTree);
        int n = parseTree.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(Trees.getDescendants(parseTree.getChild(i)));
        }
        return arrayList;
    }

    public static List<ParseTree> descendants(ParseTree parseTree) {
        return Trees.getDescendants(parseTree);
    }

    public static ParserRuleContext getRootOfSubtreeEnclosingRegion(ParseTree parseTree, int n, int n2) {
        ParserRuleContext parserRuleContext;
        int n3 = parseTree.getChildCount();
        for (int i = 0; i < n3; ++i) {
            ParseTree parseTree2 = parseTree.getChild(i);
            ParserRuleContext parserRuleContext2 = Trees.getRootOfSubtreeEnclosingRegion(parseTree2, n, n2);
            if (parserRuleContext2 == null) continue;
            return parserRuleContext2;
        }
        if (parseTree instanceof ParserRuleContext && n >= (parserRuleContext = (ParserRuleContext)parseTree).getStart().getTokenIndex() && (parserRuleContext.getStop() == null || n2 <= parserRuleContext.getStop().getTokenIndex())) {
            return parserRuleContext;
        }
        return null;
    }

    public static void stripChildrenOutOfRange(ParserRuleContext parserRuleContext, ParserRuleContext parserRuleContext2, int n, int n2) {
        if (parserRuleContext == null) {
            return;
        }
        for (int i = 0; i < parserRuleContext.getChildCount(); ++i) {
            ParseTree parseTree = parserRuleContext.getChild(i);
            Interval interval = parseTree.getSourceInterval();
            if (!(parseTree instanceof ParserRuleContext) || interval.b >= n && interval.a <= n2 || !Trees.isAncestorOf(parseTree, parserRuleContext2)) continue;
            CommonToken commonToken = new CommonToken(0, "...");
            parserRuleContext.children.set(i, new TerminalNodeImpl(commonToken));
        }
    }

    public static Tree findNodeSuchThat(Tree tree, Predicate<Tree> predicate) {
        if (predicate.test(tree)) {
            return tree;
        }
        if (tree == null) {
            return null;
        }
        int n = tree.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree tree2 = Trees.findNodeSuchThat(tree.getChild(i), predicate);
            if (tree2 == null) continue;
            return tree2;
        }
        return null;
    }

    private Trees() {
    }
}

