/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.xpath;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.xpath.XPathElement;
import org.antlr.v4.runtime.tree.xpath.XPathLexer;
import org.antlr.v4.runtime.tree.xpath.XPathLexerErrorListener;
import org.antlr.v4.runtime.tree.xpath.XPathRuleAnywhereElement;
import org.antlr.v4.runtime.tree.xpath.XPathRuleElement;
import org.antlr.v4.runtime.tree.xpath.XPathTokenAnywhereElement;
import org.antlr.v4.runtime.tree.xpath.XPathTokenElement;
import org.antlr.v4.runtime.tree.xpath.XPathWildcardAnywhereElement;
import org.antlr.v4.runtime.tree.xpath.XPathWildcardElement;

public class XPath {
    public static final String WILDCARD = "*";
    public static final String NOT = "!";
    protected String path;
    protected XPathElement[] elements;
    protected Parser parser;

    public XPath(Parser parser, String string) {
        this.parser = parser;
        this.path = string;
        this.elements = this.split(string);
    }

    public XPathElement[] split(String string) {
        ANTLRInputStream aNTLRInputStream;
        try {
            aNTLRInputStream = new ANTLRInputStream(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not read path: " + string, iOException);
        }
        XPathLexer xPathLexer = new XPathLexer(aNTLRInputStream){

            @Override
            public void recover(LexerNoViableAltException lexerNoViableAltException) {
                throw lexerNoViableAltException;
            }
        };
        xPathLexer.removeErrorListeners();
        xPathLexer.addErrorListener(new XPathLexerErrorListener());
        CommonTokenStream commonTokenStream = new CommonTokenStream(xPathLexer);
        try {
            commonTokenStream.fill();
        }
        catch (LexerNoViableAltException lexerNoViableAltException) {
            int n = xPathLexer.getCharPositionInLine();
            String string2 = "Invalid tokens or characters at index " + n + " in path '" + string + "'";
            throw new IllegalArgumentException(string2, lexerNoViableAltException);
        }
        List<Token> list2 = commonTokenStream.getTokens();
        ArrayList<XPathElement> arrayList = new ArrayList<XPathElement>();
        int n = list2.size();
        int n2 = 0;
        block9: while (n2 < n) {
            Token token = list2.get(n2);
            Token token2 = null;
            switch (token.getType()) {
                case 3: 
                case 4: {
                    boolean bl;
                    boolean bl2 = token.getType() == 3;
                    token2 = list2.get(++n2);
                    boolean bl3 = bl = token2.getType() == 6;
                    if (bl) {
                        token2 = list2.get(++n2);
                    }
                    XPathElement xPathElement = this.getXPathElement(token2, bl2);
                    xPathElement.invert = bl;
                    arrayList.add(xPathElement);
                    ++n2;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    arrayList.add(this.getXPathElement(token, false));
                    ++n2;
                    break;
                }
                case -1: {
                    break block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknowth path element " + token);
                }
            }
        }
        return arrayList.toArray(new XPathElement[0]);
    }

    protected XPathElement getXPathElement(Token token, boolean bl) {
        if (token.getType() == -1) {
            throw new IllegalArgumentException("Missing path element at end of path");
        }
        String string = token.getText();
        int n = this.parser.getTokenType(string);
        int n2 = this.parser.getRuleIndex(string);
        switch (token.getType()) {
            case 5: {
                return bl ? new XPathWildcardAnywhereElement() : new XPathWildcardElement();
            }
            case 1: 
            case 8: {
                if (n == 0) {
                    throw new IllegalArgumentException(string + " at index " + token.getStartIndex() + " isn't a valid token name");
                }
                return bl ? new XPathTokenAnywhereElement(string, n) : new XPathTokenElement(string, n);
            }
        }
        if (n2 == -1) {
            throw new IllegalArgumentException(string + " at index " + token.getStartIndex() + " isn't a valid rule name");
        }
        return bl ? new XPathRuleAnywhereElement(string, n2) : new XPathRuleElement(string, n2);
    }

    public static Collection<ParseTree> findAll(ParseTree parseTree, String string, Parser parser) {
        XPath xPath = new XPath(parser, string);
        return xPath.evaluate(parseTree);
    }

    public Collection<ParseTree> evaluate(ParseTree parseTree) {
        ParserRuleContext parserRuleContext = new ParserRuleContext();
        parserRuleContext.children = Collections.singletonList(parseTree);
        Set<ParseTree> set = Collections.singleton(parserRuleContext);
        for (int i = 0; i < this.elements.length; ++i) {
            LinkedHashSet<ParseTree> linkedHashSet = new LinkedHashSet<ParseTree>();
            for (ParseTree parseTree2 : set) {
                if (parseTree2.getChildCount() <= 0) continue;
                Collection<ParseTree> collection = this.elements[i].evaluate(parseTree2);
                linkedHashSet.addAll(collection);
            }
            set = linkedHashSet;
        }
        return set;
    }
}

