/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.module.metrics;

import java.util.Arrays;
import java.util.stream.Collectors;

public class JsonBuilder {
    private StringBuilder builder = new StringBuilder();
    private boolean hasAtLeastOneField = false;

    public JsonBuilder() {
        this.builder.append("{");
    }

    public JsonBuilder appendNull(String key2) {
        this.appendFieldUnescaped(key2, "null");
        return this;
    }

    public JsonBuilder appendField(String key2, String value) {
        if (value == null) {
            throw new IllegalArgumentException("JSON value must not be null");
        }
        this.appendFieldUnescaped(key2, "\"" + JsonBuilder.escape(value) + "\"");
        return this;
    }

    public JsonBuilder appendField(String key2, int value) {
        this.appendFieldUnescaped(key2, String.valueOf(value));
        return this;
    }

    public JsonBuilder appendField(String key2, JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON object must not be null");
        }
        this.appendFieldUnescaped(key2, object.toString());
        return this;
    }

    public JsonBuilder appendField(String key2, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        String escapedValues = Arrays.stream(values).map(value -> "\"" + JsonBuilder.escape(value) + "\"").collect(Collectors.joining(","));
        this.appendFieldUnescaped(key2, "[" + escapedValues + "]");
        return this;
    }

    public JsonBuilder appendField(String key2, int[] values) {
        if (values == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        String escapedValues = Arrays.stream(values).mapToObj(String::valueOf).collect(Collectors.joining(","));
        this.appendFieldUnescaped(key2, "[" + escapedValues + "]");
        return this;
    }

    public JsonBuilder appendField(String key2, JsonObject[] values) {
        if (values == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        String escapedValues = Arrays.stream(values).map(JsonObject::toString).collect(Collectors.joining(","));
        this.appendFieldUnescaped(key2, "[" + escapedValues + "]");
        return this;
    }

    private void appendFieldUnescaped(String key2, String escapedValue) {
        if (this.builder == null) {
            throw new IllegalStateException("JSON has already been built");
        }
        if (key2 == null) {
            throw new IllegalArgumentException("JSON key must not be null");
        }
        if (this.hasAtLeastOneField) {
            this.builder.append(",");
        }
        this.builder.append("\"").append(JsonBuilder.escape(key2)).append("\":").append(escapedValue);
        this.hasAtLeastOneField = true;
    }

    public JsonObject build() {
        if (this.builder == null) {
            throw new IllegalStateException("JSON has already been built");
        }
        JsonObject object = new JsonObject(this.builder.append("}").toString());
        this.builder = null;
        return object;
    }

    private static String escape(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (c <= '\u000f') {
                builder.append("\\u000").append(Integer.toHexString(c));
                continue;
            }
            if (c <= '\u001f') {
                builder.append("\\u00").append(Integer.toHexString(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static class JsonObject {
        private final String value;

        private JsonObject(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

