/*
 * Decompiled with CFR 0.152.
 */
package cn.inrhor.imipetcore.taboolib.platform;

import cn.inrhor.imipetcore.taboolib.common.LifeCycle;
import cn.inrhor.imipetcore.taboolib.common.TabooLibCommon;
import cn.inrhor.imipetcore.taboolib.common.classloader.IsolatedClassLoader;
import cn.inrhor.imipetcore.taboolib.common.io.Project1Kt;
import cn.inrhor.imipetcore.taboolib.common.platform.Platform;
import cn.inrhor.imipetcore.taboolib.common.platform.PlatformSide;
import cn.inrhor.imipetcore.taboolib.common.platform.Plugin;
import cn.inrhor.imipetcore.taboolib.common.platform.function.ExecutorKt;
import cn.inrhor.imipetcore.taboolib.library.reflex.Reflex;
import cn.inrhor.imipetcore.taboolib.platform.BukkitWorldGenerator;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PlatformSide(value={Platform.BUKKIT})
public class BukkitPlugin
extends JavaPlugin {
    @Nullable
    private static Plugin pluginInstance;
    private static BukkitPlugin instance;
    private static Class<?> delegateClass;
    private static Object delegateObject;

    public BukkitPlugin() {
        instance = this;
        if (IsolatedClassLoader.isEnabled()) {
            try {
                delegateClass.getMethod("onInit", new Class[0]).invoke(delegateObject, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            BukkitPlugin.injectAccess();
            TabooLibCommon.lifeCycle(LifeCycle.INIT);
        }
    }

    public void onLoad() {
        if (IsolatedClassLoader.isEnabled()) {
            try {
                delegateClass.getMethod("onLoad", new Class[0]).invoke(delegateObject, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            TabooLibCommon.lifeCycle(LifeCycle.LOAD);
            if (pluginInstance == null) {
                pluginInstance = Project1Kt.findImplementation(Plugin.class);
            }
            if (pluginInstance != null && !TabooLibCommon.isStopped()) {
                pluginInstance.onLoad();
            }
        }
    }

    public void onEnable() {
        if (IsolatedClassLoader.isEnabled()) {
            try {
                delegateClass.getMethod("onEnable", new Class[0]).invoke(delegateObject, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
        if (!TabooLibCommon.isStopped()) {
            if (pluginInstance != null) {
                pluginInstance.onEnable();
            }
            try {
                ExecutorKt.startExecutor();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!TabooLibCommon.isStopped()) {
            Bukkit.getScheduler().runTask((org.bukkit.plugin.Plugin)this, new Runnable(){

                @Override
                public void run() {
                    TabooLibCommon.lifeCycle(LifeCycle.ACTIVE);
                    if (pluginInstance != null) {
                        pluginInstance.onActive();
                    }
                }
            });
        }
    }

    public void onDisable() {
        if (IsolatedClassLoader.isEnabled()) {
            try {
                delegateClass.getMethod("onDisable", new Class[0]).invoke(delegateObject, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
            if (pluginInstance != null && !TabooLibCommon.isStopped()) {
                pluginInstance.onDisable();
            }
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, String id2) {
        try {
            if (pluginInstance instanceof BukkitWorldGenerator) {
                return ((BukkitWorldGenerator)pluginInstance).getDefaultWorldGenerator(worldName, id2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public File getFile() {
        return super.getFile();
    }

    @NotNull
    public static BukkitPlugin getInstance() {
        return instance;
    }

    @Nullable
    public static Plugin getPluginInstance() {
        return pluginInstance;
    }

    static void injectAccess() {
        try {
            PluginDescriptionFile description = (PluginDescriptionFile)Reflex.Companion.getProperty(BukkitPlugin.class.getClassLoader(), "description", false, true, false);
            Set accessSelf = (Set)Reflex.Companion.getProperty(BukkitPlugin.class.getClassLoader(), "seenIllegalAccess", false, true, false);
            for (org.bukkit.plugin.Plugin plugin2 : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin2.getClass().getName().endsWith("platform.BukkitPlugin")) continue;
                Set accessOther = (Set)Reflex.Companion.getProperty(plugin2.getClass().getClassLoader(), "seenIllegalAccess", false, true, false);
                accessOther.add(description.getName());
                accessSelf.add(plugin2.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        if (IsolatedClassLoader.isEnabled()) {
            try {
                IsolatedClassLoader loader = new IsolatedClassLoader(new URL[]{BukkitPlugin.class.getProtectionDomain().getCodeSource().getLocation()}, BukkitPlugin.class.getClassLoader());
                delegateClass = Class.forName("cn.inrhor.imipetcore.taboolib.platform.BukkitPluginDelegate", true, loader);
                delegateObject = delegateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                delegateClass.getMethod("onConst", new Class[0]).invoke(delegateObject, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            TabooLibCommon.lifeCycle(LifeCycle.CONST, Platform.BUKKIT);
            if (TabooLibCommon.isKotlinEnvironment()) {
                pluginInstance = Project1Kt.findImplementation(Plugin.class);
            }
        }
    }
}

