/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.core.animation;

import cc.trixey.invero.core.animation.Cycle;
import cc.trixey.invero.core.animation.CycleMode;
import kotlin.Metadata;
import kotlin1810.collections.ArraysKt;
import kotlin1810.jvm.internal.DefaultConstructorMarker;
import kotlin1810.jvm.internal.Intrinsics;
import kotlin1810.random.Random;
import kotlin1810.ranges.IntRange;
import kotlin1810.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\r\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u0015J\u0006\u0010\"\u001a\u00020\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcc/trixey/invero/core/animation/Cyclic;", "T", "Lcc/trixey/invero/core/animation/Cycle;", "value", "", "mode", "Lcc/trixey/invero/core/animation/CycleMode;", "([Ljava/lang/Object;Lcc/trixey/invero/core/animation/CycleMode;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "maxIndex", "getMaxIndex", "getMode", "()Lcc/trixey/invero/core/animation/CycleMode;", "setMode", "(Lcc/trixey/invero/core/animation/CycleMode;)V", "reversing", "", "getReversing", "()Z", "setReversing", "(Z)V", "getValue$module_core", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "cycle", "", "get", "()Ljava/lang/Object;", "isAnimationEnded", "isSingle", "module-core"})
public final class Cyclic<T>
implements Cycle<T> {
    @NotNull
    private final T[] value;
    @NotNull
    private CycleMode mode;
    private int index;
    private final int maxIndex;
    private boolean reversing;

    public Cyclic(@NotNull T[] value2, @NotNull CycleMode mode) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.value = value2;
        this.mode = mode;
        this.maxIndex = ArraysKt.getIndices((Object[])this.value).getLast();
    }

    public /* synthetic */ Cyclic(Object[] objectArray, CycleMode cycleMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cycleMode = CycleMode.LOOP;
        }
        this(objectArray, cycleMode);
    }

    @NotNull
    public final T[] getValue$module_core() {
        return this.value;
    }

    @Override
    @NotNull
    public CycleMode getMode() {
        return this.mode;
    }

    public void setMode(@NotNull CycleMode cycleMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)cycleMode), (String)"<set-?>");
        this.mode = cycleMode;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getMaxIndex() {
        return this.maxIndex;
    }

    public final boolean getReversing() {
        return this.reversing;
    }

    public final void setReversing(boolean bl) {
        this.reversing = bl;
    }

    public final boolean isSingle() {
        return this.value.length <= 1;
    }

    public final boolean isAnimationEnded() {
        return this.getMode() == CycleMode.ONE_WAY && this.index == this.maxIndex;
    }

    @Override
    public T get() {
        return this.value[this.index];
    }

    @Override
    public void cycle() {
        if (this.getMode().isRandom()) {
            this.index = RangesKt.random((IntRange)ArraysKt.getIndices((Object[])this.value), (Random)((Random)Random.Default));
        } else if (this.getMode().isOneway() && this.index < this.maxIndex) {
            int n = this.index;
            this.index = n + 1;
        } else if (this.getMode().isLoop()) {
            if (this.index == this.maxIndex) {
                this.index = 0;
            } else {
                int n = this.index;
                this.index = n + 1;
            }
        } else if (this.getMode().isReversable()) {
            if (this.reversing) {
                int n = this.index;
                this.index = n + -1;
                if (this.index == 0) {
                    this.reversing = false;
                }
            } else {
                int n = this.index;
                this.index = n + 1;
                if (this.index == this.maxIndex) {
                    this.reversing = true;
                }
            }
        }
    }

    @Override
    public T getAndCycle() {
        return Cycle.DefaultImpls.getAndCycle(this);
    }
}

