/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.chat;

import cc.trixey.invero.taboolib.module.chat.StandardColors;
import java.awt.Color;
import java.util.Optional;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;

public class HexColor {
    private static boolean isLegacy = false;

    @NotNull
    public static String translate(String in) {
        if (isLegacy) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)in).replace("&#", "\u00a7#");
        }
        StringBuilder builder = new StringBuilder();
        char[] chars = in.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i + 1 < chars.length && chars[i] == '&' && chars[i + 1] == '{') {
                ChatColor chatColor = null;
                char[] match = new char[]{};
                for (int j = i + 2; j < chars.length && chars[j] != '}'; ++j) {
                    match = HexColor.arrayAppend(match, chars[j]);
                }
                if (match.length != 11 || match[3] != ',' && match[3] != '-' || match[7] != ',' && match[7] != '-') {
                    if (match.length == 7 && match[0] == '#') {
                        try {
                            chatColor = ChatColor.of((String)HexColor.toString(match));
                        }
                        catch (IllegalArgumentException j) {}
                    } else {
                        Optional<StandardColors> knownColor = StandardColors.match(HexColor.toString(match));
                        if (knownColor.isPresent()) {
                            chatColor = knownColor.get().toChatColor();
                        }
                    }
                } else {
                    chatColor = ChatColor.of((Color)new Color(HexColor.toInt(match, 0, 3), HexColor.toInt(match, 4, 7), HexColor.toInt(match, 8, 11)));
                }
                if (chatColor == null) continue;
                builder.append(chatColor);
                i += match.length + 2;
                continue;
            }
            builder.append(chars[i]);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)builder.toString());
    }

    public static String getColorCode(int color) {
        return ChatColor.of((Color)new Color(color)).toString();
    }

    private static char[] arrayAppend(char[] chars, char in) {
        char[] newChars = new char[chars.length + 1];
        System.arraycopy(chars, 0, newChars, 0, chars.length);
        newChars[chars.length] = in;
        return newChars;
    }

    private static String toString(char[] chars) {
        StringBuilder builder = new StringBuilder();
        for (char c : chars) {
            builder.append(c);
        }
        return builder.toString();
    }

    private static int toInt(char[] chars, int start, int end) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            builder.append(chars[i]);
        }
        return Integer.parseInt(builder.toString());
    }

    static {
        try {
            ChatColor.of((Color)Color.BLACK);
        }
        catch (NoSuchMethodError var1) {
            isLegacy = true;
        }
    }
}

