/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.metrics;

import cc.trixey.invero.taboolib.module.metrics.JsonBuilder;
import java.util.function.BiConsumer;

public abstract class CustomChart {
    private final String chartId;

    protected CustomChart(String chartId) {
        if (chartId == null) {
            throw new IllegalArgumentException("chartId must not be null");
        }
        this.chartId = chartId;
    }

    public JsonBuilder.JsonObject getRequestJsonObject(BiConsumer<String, Throwable> errorLogger, boolean logErrors) {
        JsonBuilder builder = new JsonBuilder();
        builder.appendField("chartId", this.chartId);
        try {
            JsonBuilder.JsonObject data = this.getChartData();
            if (data == null) {
                return null;
            }
            builder.appendField("data", data);
        }
        catch (Throwable t) {
            if (logErrors) {
                errorLogger.accept("Failed to get data for custom chart with id " + this.chartId, t);
            }
            return null;
        }
        return builder.build();
    }

    protected abstract JsonBuilder.JsonObject getChartData() throws Exception;
}

