/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.adventure.util;

import cc.trixey.invero.common.adventure.adventure.internal.properties.AdventureProperties;
import cc.trixey.invero.common.adventure.adventure.util.Services0;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public final class Services {
    private static final boolean SERVICE_LOAD_FAILURES_ARE_FATAL = Boolean.TRUE.equals(AdventureProperties.SERVICE_LOAD_FAILURES_ARE_FATAL.value());

    private Services() {
    }

    @NotNull
    public static <P> Optional<P> service(@NotNull Class<P> type2) {
        ServiceLoader<P> loader = Services0.loader(type2);
        Iterator<P> it = loader.iterator();
        while (it.hasNext()) {
            P instance2;
            try {
                instance2 = it.next();
            }
            catch (Throwable t) {
                if (!SERVICE_LOAD_FAILURES_ARE_FATAL) continue;
                throw new IllegalStateException("Encountered an exception loading service " + type2, t);
            }
            if (it.hasNext()) {
                throw new IllegalStateException("Expected to find one service " + type2 + ", found multiple");
            }
            return Optional.of(instance2);
        }
        return Optional.empty();
    }
}

