/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.common.adventure.examination;

import cc.trixey.invero.common.adventure.examination.Examinable;
import cc.trixey.invero.common.adventure.examination.ExaminableProperty;
import cc.trixey.invero.common.adventure.examination.Examiner;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExaminer<R>
implements Examiner<R> {
    @Override
    @NotNull
    public R examine(@Nullable Object value2) {
        if (value2 == null) {
            return this.nil();
        }
        if (value2 instanceof String) {
            return this.examine((String)value2);
        }
        if (value2 instanceof Examinable) {
            return this.examine((Examinable)value2);
        }
        if (value2 instanceof Collection) {
            return this.collection((Collection)value2);
        }
        if (value2 instanceof Map) {
            return this.map((Map)value2);
        }
        if (value2.getClass().isArray()) {
            Class<?> type2 = value2.getClass().getComponentType();
            if (type2.isPrimitive()) {
                if (type2 == Boolean.TYPE) {
                    return this.examine((boolean[])value2);
                }
                if (type2 == Byte.TYPE) {
                    return this.examine((byte[])value2);
                }
                if (type2 == Character.TYPE) {
                    return this.examine((char[])value2);
                }
                if (type2 == Double.TYPE) {
                    return this.examine((double[])value2);
                }
                if (type2 == Float.TYPE) {
                    return this.examine((float[])value2);
                }
                if (type2 == Integer.TYPE) {
                    return this.examine((int[])value2);
                }
                if (type2 == Long.TYPE) {
                    return this.examine((long[])value2);
                }
                if (type2 == Short.TYPE) {
                    return this.examine((short[])value2);
                }
            }
            return this.array((Object[])value2);
        }
        if (value2 instanceof Boolean) {
            return this.examine((Boolean)value2);
        }
        if (value2 instanceof Character) {
            return this.examine(((Character)value2).charValue());
        }
        if (value2 instanceof Number) {
            if (value2 instanceof Byte) {
                return this.examine((Byte)value2);
            }
            if (value2 instanceof Double) {
                return this.examine((Double)value2);
            }
            if (value2 instanceof Float) {
                return this.examine(((Float)value2).floatValue());
            }
            if (value2 instanceof Integer) {
                return this.examine((Integer)value2);
            }
            if (value2 instanceof Long) {
                return this.examine((Long)value2);
            }
            if (value2 instanceof Short) {
                return this.examine((Short)value2);
            }
        } else if (value2 instanceof BaseStream) {
            if (value2 instanceof Stream) {
                return this.stream((Stream)value2);
            }
            if (value2 instanceof DoubleStream) {
                return this.stream((DoubleStream)value2);
            }
            if (value2 instanceof IntStream) {
                return this.stream((IntStream)value2);
            }
            if (value2 instanceof LongStream) {
                return this.stream((LongStream)value2);
            }
        }
        return this.scalar(value2);
    }

    @NotNull
    private <E> R array(E @NotNull [] array) {
        return (R)this.array(array, Arrays.stream(array).map(this::examine));
    }

    @NotNull
    protected abstract <E> R array(E @NotNull [] var1, @NotNull Stream<R> var2);

    @NotNull
    private <E> R collection(@NotNull Collection<E> collection) {
        return (R)this.collection(collection, collection.stream().map(this::examine));
    }

    @NotNull
    protected abstract <E> R collection(@NotNull Collection<E> var1, @NotNull Stream<R> var2);

    @Override
    @NotNull
    public R examine(@NotNull String name2, @NotNull Stream<? extends ExaminableProperty> properties) {
        return this.examinable(name2, properties.map((? super T property) -> new AbstractMap.SimpleImmutableEntry(property.name(), property.examine(this))));
    }

    @NotNull
    protected abstract R examinable(@NotNull String var1, @NotNull Stream<Map.Entry<String, R>> var2);

    @NotNull
    private <K, V> R map(@NotNull Map<K, V> map2) {
        return this.map(map2, map2.entrySet().stream().map((? super T entry) -> new AbstractMap.SimpleImmutableEntry<R, R>(this.examine(entry.getKey()), this.examine(entry.getValue()))));
    }

    @NotNull
    protected abstract <K, V> R map(@NotNull Map<K, V> var1, @NotNull Stream<Map.Entry<R, R>> var2);

    @NotNull
    protected abstract R nil();

    @NotNull
    protected abstract R scalar(@NotNull Object var1);

    @NotNull
    protected abstract <T> R stream(@NotNull Stream<T> var1);

    @NotNull
    protected abstract R stream(@NotNull DoubleStream var1);

    @NotNull
    protected abstract R stream(@NotNull IntStream var1);

    @NotNull
    protected abstract R stream(@NotNull LongStream var1);

    @Override
    @NotNull
    public R examine(boolean @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(byte @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(char @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(double @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(float @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(int @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(long @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @Override
    @NotNull
    public R examine(short @Nullable [] values) {
        if (values == null) {
            return this.nil();
        }
        return (R)this.array(values.length, (int index) -> this.examine(values[index]));
    }

    @NotNull
    protected abstract R array(int var1, IntFunction<R> var2);
}

