/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.jarrelocator;

import cc.trixey.invero.taboolib.library.jarrelocator.JarRelocatorTask;
import cc.trixey.invero.taboolib.library.jarrelocator.RelocatingRemapper;
import cc.trixey.invero.taboolib.library.jarrelocator.Relocation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public final class JarRelocator {
    private final File input;
    private final File output;
    private final RelocatingRemapper remapper;
    private final AtomicBoolean used = new AtomicBoolean(false);

    public JarRelocator(File input, File output, Collection<Relocation> relocations) {
        this.input = input;
        this.output = output;
        this.remapper = new RelocatingRemapper(relocations);
    }

    public JarRelocator(File input, File output, Map<String, String> relocations) {
        this.input = input;
        this.output = output;
        ArrayList<Relocation> c = new ArrayList<Relocation>(relocations.size());
        for (Map.Entry<String, String> entry : relocations.entrySet()) {
            c.add(new Relocation(entry.getKey(), entry.getValue()));
        }
        this.remapper = new RelocatingRemapper(c);
    }

    public void run() throws IOException {
        if (this.used.getAndSet(true)) {
            throw new IllegalStateException("#run has already been called on this instance");
        }
        try (JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.output)));
             JarFile in = new JarFile(this.input);){
            JarRelocatorTask task2 = new JarRelocatorTask(this.remapper, out, in);
            task2.processEntries();
        }
    }
}

