/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.library.kether;

import cc.trixey.invero.taboolib.library.kether.QuestAction;
import cc.trixey.invero.taboolib.library.kether.QuestContext;
import cc.trixey.invero.taboolib.module.kether.RemoteQuestAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ParsedAction<A> {
    private final QuestAction<A> action;
    private final Map<String, Object> properties;

    public ParsedAction(QuestAction<A> action) {
        this(action, new HashMap<String, Object>());
    }

    public ParsedAction(QuestAction<A> action, Map<String, Object> properties) {
        this.action = action;
        this.properties = properties;
    }

    public CompletableFuture<A> process(QuestContext.Frame frame) {
        return this.action.process(frame);
    }

    public <T> T get(ActionProperty<T> key2) throws NullPointerException {
        return (T)Objects.requireNonNull(this.properties.get(((ActionProperty)key2).id), ((ActionProperty)key2).id);
    }

    public <T> T get(ActionProperty<T> key2, T defaultValue) {
        Object value2 = this.properties.get(((ActionProperty)key2).id);
        return (T)(value2 == null ? defaultValue : value2);
    }

    public <T> void set(ActionProperty<T> key2, T value2) {
        Objects.requireNonNull(value2);
        this.properties.put(((ActionProperty)key2).id, value2);
    }

    public <T> boolean has(ActionProperty<T> key2) {
        return this.properties.containsKey(((ActionProperty)key2).id);
    }

    public QuestAction<?> getAction() {
        return this.action;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "Parsed[" + this.action + ", " + this.properties + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParsedAction)) {
            return false;
        }
        ParsedAction that = (ParsedAction)o;
        return Objects.equals(this.getAction(this), this.getAction(that)) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getAction(this), this.getProperties());
    }

    private Object getAction(ParsedAction<?> action) {
        return action.action instanceof RemoteQuestAction ? ((RemoteQuestAction)action.action).getSource() : action.action;
    }

    public static <T> ParsedAction<T> noop() {
        return new ParsedAction(QuestAction.noop());
    }

    public static final class ActionProperty<T> {
        private final String id;

        private ActionProperty(String id2) {
            Objects.requireNonNull(id2);
            this.id = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionProperty that = (ActionProperty)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "ActionProperty{id='" + this.id + '\'' + '}';
        }

        public static <T> ActionProperty<T> of(String id2) {
            return new ActionProperty<T>(id2);
        }
    }
}

