/*
 * Decompiled with CFR 0.152.
 */
package cc.trixey.invero.taboolib.module.nms;

import cc.trixey.invero.taboolib.common.LifeCycle;
import cc.trixey.invero.taboolib.common.TabooLibCommon;
import cc.trixey.invero.taboolib.common.platform.Awake;
import cc.trixey.invero.taboolib.common.platform.Platform;
import cc.trixey.invero.taboolib.common.platform.PlatformSide;
import cc.trixey.invero.taboolib.common.platform.event.EventPriority;
import cc.trixey.invero.taboolib.common.platform.event.SubscribeEvent;
import cc.trixey.invero.taboolib.common.platform.function.IOKt;
import cc.trixey.invero.taboolib.common.platform.function.ListenerKt;
import cc.trixey.invero.taboolib.module.nms.ChannelHandler;
import cc.trixey.invero.taboolib.module.nms.ConnectionGetter;
import cc.trixey.invero.taboolib.module.nms.MinecraftVersion;
import cc.trixey.invero.taboolib.module.nms.PacketReceiveEvent;
import cc.trixey.invero.taboolib.module.nms.PacketSendEvent;
import cc.trixey.invero.taboolib.platform.util.BukkitServerKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin1810.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@PlatformSide(value={Platform.BUKKIT})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\b\u0010\u0015\u001a\u00020\u000bH\u0003J\b\u0010\u0016\u001a\u00020\u000bH\u0003J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u001bH\u0003J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcc/trixey/invero/taboolib/module/nms/ChannelExecutor;", "", "()V", "id", "", "isDisabled", "", "pool", "Ljava/util/concurrent/ExecutorService;", "kotlin1810.jvm.PlatformType", "addPlayerChannel", "", "player", "Lorg/bukkit/entity/Player;", "address", "Ljava/net/InetAddress;", "disable", "getPlayerChannel", "Lio/netty/channel/Channel;", "init", "isPacketEventListened", "onDisable", "onEnable", "onJoin", "e", "Lorg/bukkit/event/player/PlayerLoginEvent;", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "removePlayerChannel", "async", "module-nms"})
public final class ChannelExecutor {
    @NotNull
    public static final ChannelExecutor INSTANCE = new ChannelExecutor();
    @NotNull
    private static final String id = "cc.trixey.invero.taboolib_" + IOKt.getPluginId() + "_packet_handler";
    private static final ExecutorService pool = Executors.newSingleThreadExecutor();
    private static boolean isDisabled;

    private ChannelExecutor() {
    }

    public final void disable() {
        isDisabled = true;
    }

    public final boolean isPacketEventListened() {
        return ListenerKt.isListened(PacketSendEvent.class) || ListenerKt.isListened(PacketReceiveEvent.class);
    }

    @NotNull
    public final Channel getPlayerChannel(@NotNull InetAddress address, boolean init2) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return ConnectionGetter.Companion.getInstance().getChannel(ConnectionGetter.Companion.getInstance().getConnection(address, init2));
    }

    public final void addPlayerChannel(@NotNull Player player2, @NotNull InetAddress address) {
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (isDisabled || !this.isPacketEventListened()) {
            return;
        }
        if (!MinecraftVersion.INSTANCE.isSupported()) {
            Object[] objectArray = new Object[]{"Unsupported Minecraft version, packet handler will not be added."};
            IOKt.warning(objectArray);
            return;
        }
        try {
            ChannelPipeline pipeline = this.getPlayerChannel(address, true).pipeline();
            try {
                pipeline.remove(id);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (pipeline.get("packet_handler") == null) {
                pipeline.addLast(id, (io.netty.channel.ChannelHandler)new ChannelHandler(player2));
            } else {
                pipeline.addBefore("packet_handler", id, (io.netty.channel.ChannelHandler)new ChannelHandler(player2));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public final void removePlayerChannel(@NotNull Player player2, boolean async) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        if (isDisabled || !this.isPacketEventListened()) {
            return;
        }
        if (!MinecraftVersion.INSTANCE.isSupported()) {
            Object[] objectArray = new Object[]{"Unsupported Minecraft version, packet handler will not be added."};
            IOKt.warning(objectArray);
            return;
        }
        InetSocketAddress inetSocketAddress = player2.getAddress();
        InetAddress inetAddress2 = inetAddress = inetSocketAddress == null ? null : inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return;
        }
        InetAddress address = inetAddress;
        if (async) {
            pool.submit(() -> ChannelExecutor.removePlayerChannel$process(address));
        } else {
            ChannelExecutor.removePlayerChannel$process(address);
        }
    }

    public static /* synthetic */ void removePlayerChannel$default(ChannelExecutor channelExecutor, Player player2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        channelExecutor.removePlayerChannel(player2, bl);
    }

    @SubscribeEvent(priority=EventPriority.MONITOR)
    private final void onJoin(PlayerLoginEvent e2) {
        if (e2.getResult() == PlayerLoginEvent.Result.ALLOWED) {
            Object object = e2.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.player");
            Player player2 = object;
            object = e2.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.address");
            this.addPlayerChannel(player2, (InetAddress)object);
        }
    }

    @SubscribeEvent
    private final void onQuit(PlayerQuitEvent e2) {
        if (TabooLibCommon.isStopped()) {
            return;
        }
        InetSocketAddress inetSocketAddress = e2.getPlayer().getAddress();
        if (inetSocketAddress == null) {
            return;
        }
        InetSocketAddress inetSocketAddress2 = inetSocketAddress;
        ConnectionGetter.Companion.getInstance().release(inetSocketAddress2);
    }

    @Awake(value=LifeCycle.ACTIVE)
    private final void onEnable() {
        if (TabooLibCommon.isStopped()) {
            return;
        }
        Iterable $this$forEach$iv = BukkitServerKt.getOnlinePlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InetAddress address;
            Player it = (Player)element$iv;
            boolean bl = false;
            Object[] objectArray = it.getAddress();
            InetAddress inetAddress = address = objectArray == null ? null : objectArray.getAddress();
            if (address == null) {
                objectArray = new Object[]{"Cannot get player address: " + it.getName() + " (" + it.getAddress() + ')'};
                IOKt.warning(objectArray);
                continue;
            }
            INSTANCE.addPlayerChannel(it, address);
        }
    }

    @Awake(value=LifeCycle.DISABLE)
    private final void onDisable() {
        if (TabooLibCommon.isStopped()) {
            return;
        }
        Iterable $this$forEach$iv = BukkitServerKt.getOnlinePlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            INSTANCE.removePlayerChannel(it, false);
        }
    }

    private static final void removePlayerChannel$process(InetAddress address) {
        try {
            ChannelPipeline pipeline = INSTANCE.getPlayerChannel(address, false).pipeline();
            if (pipeline.get(id) != null) {
                pipeline.remove(id);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

