/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins.Plugins.FlagResult;
import dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins.Plugins.Flags;
import dev.lone.itemsadder.Core.OtherPlugins.ProtectionPlugins.ProtectionPlugins;
import ia.m.O;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldGuardFlagsManager {
    private static boolean areFlagsRegistered;
    private static FlagRegistry registry;

    public static void registerFlags() {
        try {
            if (!ProtectionPlugins.hasWorldGuard) {
                return;
            }
            if (areFlagsRegistered) {
                return;
            }
            areFlagsRegistered = true;
            registry = WorldGuard.getInstance().getFlagRegistry();
            Flags.FURNITURE_SIT = WorldGuardFlagsManager.registerFlag("ia-furniture-sit");
            Flags.MOVE_ITEM_TO_CAMPFIRE = WorldGuardFlagsManager.registerFlag("ia-campfire-item-add", false);
            Flags.REMOVE_ITEM_FROM_CAMPFIRE = WorldGuardFlagsManager.registerFlag("ia-campfire-item-remove", false);
            Flags.VEHICLE_SIT = WorldGuardFlagsManager.registerFlag("ia-vehicle-sit", false);
            Flags.VEHICLE_PLACE = WorldGuardFlagsManager.registerFlag("ia-vehicle-place", false);
            Flags.VEHICLE_REMOVE = WorldGuardFlagsManager.registerFlag("ia-vehicle-remove", false);
            Flags.VEHICLE_PERSONAL_SIT = WorldGuardFlagsManager.registerFlag("ia-vehicle-personal-sit");
            Flags.VEHICLE_PERSONAL_REMOVE = WorldGuardFlagsManager.registerFlag("ia-vehicle-personal-remove");
            Flags.TRADE_MACHINES_USE = WorldGuardFlagsManager.registerFlag("ia-trade-machine-use");
            Flags.PLACED_BLOCK_INTERACT = WorldGuardFlagsManager.registerFlag("ia-placed-block-interact");
            Flags.PLACED_FURNITURE_INTERACT = WorldGuardFlagsManager.registerFlag("ia-placed-furniture-interact");
            if (O.ak) {
                Flags.PLACED_ARMORSTAND_INTERACT = WorldGuardFlagsManager.registerFlag("ia-placed-armorstand-interact");
                Flags.PLACED_ITEMFRAME_INTERACT = WorldGuardFlagsManager.registerFlag("ia-placed-itemframe-interact");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static StateFlag registerFlag(String string) {
        return WorldGuardFlagsManager.registerFlag(string, true);
    }

    static StateFlag registerFlag(String string, boolean bl2) {
        Flag flag = registry.get(string);
        if (flag != null && flag instanceof StateFlag) {
            return (StateFlag)flag;
        }
        StateFlag stateFlag = new StateFlag(string, bl2);
        registry.register((Flag)stateFlag);
        return stateFlag;
    }

    public static void setHasWorldGuard(boolean bl2) {
        ProtectionPlugins.hasWorldGuard = bl2;
    }

    public static boolean hasWorldGuard() {
        return ProtectionPlugins.hasWorldGuard;
    }

    public static boolean hasBypass(LocalPlayer localPlayer, Location location) {
        return WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, BukkitAdapter.adapt((World)location.getWorld()));
    }

    public static FlagResult testEntityFlag(StateFlag stateFlag, Player player, Entity entity) {
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Entity)entity).getLocation();
        if (regionQuery.getApplicableRegions(location).getRegions().size() == 0) {
            return FlagResult.NO_REGION;
        }
        if (WorldGuardFlagsManager.hasBypass(localPlayer, entity.getLocation())) {
            return FlagResult.BYPASS;
        }
        if (regionQuery.testState(location, localPlayer, new StateFlag[]{stateFlag})) {
            return FlagResult.ALLOW;
        }
        return FlagResult.DENY;
    }

    public static FlagResult testBlockFlag(StateFlag stateFlag, Player player, Block block) {
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)block.getLocation());
        if (regionQuery.getApplicableRegions(location).getRegions().size() == 0) {
            return FlagResult.NO_REGION;
        }
        if (WorldGuardFlagsManager.hasBypass(localPlayer, block.getLocation())) {
            return FlagResult.BYPASS;
        }
        if (regionQuery.testState(location, localPlayer, new StateFlag[]{stateFlag})) {
            return FlagResult.ALLOW;
        }
        return FlagResult.DENY;
    }
}

