/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.Filter;
import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.internal.CharacterIndex;
import ia.sh.com.jayway.jsonpath.internal.filter.ExpressionNode;
import ia.sh.com.jayway.jsonpath.internal.filter.FilterCompiler$CompiledFilter;
import ia.sh.com.jayway.jsonpath.internal.filter.LogicalExpressionNode;
import ia.sh.com.jayway.jsonpath.internal.filter.LogicalOperator;
import ia.sh.com.jayway.jsonpath.internal.filter.PatternFlag;
import ia.sh.com.jayway.jsonpath.internal.filter.RelationalExpressionNode;
import ia.sh.com.jayway.jsonpath.internal.filter.RelationalOperator;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$BooleanNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$JsonNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$NumberNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$PathNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$PatternNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$StringNode;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterCompiler {
    private static final Logger logger = LoggerFactory.getLogger(FilterCompiler.class);
    private static final char DOC_CONTEXT = '$';
    private static final char EVAL_CONTEXT = '@';
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private static final char OPEN_OBJECT = '{';
    private static final char CLOSE_OBJECT = '}';
    private static final char OPEN_ARRAY = '[';
    private static final char CLOSE_ARRAY = ']';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char PERIOD = '.';
    private static final char AND = '&';
    private static final char OR = '|';
    private static final char MINUS = '-';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char EQ = '=';
    private static final char TILDE = '~';
    private static final char TRUE = 't';
    private static final char FALSE = 'f';
    private static final char NULL = 'n';
    private static final char NOT = '!';
    private static final char PATTERN = '/';
    private static final char IGNORE_CASE = 'i';
    private CharacterIndex filter;

    public static Filter compile(String string) {
        FilterCompiler filterCompiler = new FilterCompiler(string);
        return new FilterCompiler$CompiledFilter(filterCompiler.compile(), null);
    }

    private FilterCompiler(String string) {
        this.filter = new CharacterIndex(string);
        this.filter.trim();
        if (!this.filter.currentCharIs('[') || !this.filter.lastCharIs(']')) {
            throw new InvalidPathException("Filter must start with '[' and end with ']'. " + string);
        }
        this.filter.incrementPosition(1);
        this.filter.decrementEndPosition(1);
        this.filter.trim();
        if (!this.filter.currentCharIs('?')) {
            throw new InvalidPathException("Filter must start with '[?' and end with ']'. " + string);
        }
        this.filter.incrementPosition(1);
        this.filter.trim();
        if (!this.filter.currentCharIs('(') || !this.filter.lastCharIs(')')) {
            throw new InvalidPathException("Filter must start with '[?(' and end with ')]'. " + string);
        }
    }

    public Predicate compile() {
        try {
            ExpressionNode expressionNode = this.readLogicalOR();
            this.filter.skipBlanks();
            if (this.filter.inBounds()) {
                throw new InvalidPathException(String.format("Expected end of filter expression instead of: %s", this.filter.subSequence(this.filter.position(), this.filter.length())));
            }
            return expressionNode;
        }
        catch (InvalidPathException invalidPathException) {
            throw invalidPathException;
        }
        catch (Exception exception) {
            throw new InvalidPathException("Failed to parse filter: " + this.filter + ", error on position: " + this.filter.position() + ", char: " + this.filter.currentChar());
        }
    }

    private ValueNode readValueNode() {
        switch (this.filter.skipBlanks().currentChar()) {
            case '$': {
                return this.readPath();
            }
            case '@': {
                return this.readPath();
            }
            case '!': {
                this.filter.incrementPosition(1);
                switch (this.filter.skipBlanks().currentChar()) {
                    case '$': {
                        return this.readPath();
                    }
                    case '@': {
                        return this.readPath();
                    }
                }
                throw new InvalidPathException(String.format("Unexpected character: %c", Character.valueOf('!')));
            }
        }
        return this.readLiteral();
    }

    private ValueNode readLiteral() {
        switch (this.filter.skipBlanks().currentChar()) {
            case '\'': {
                return this.readStringLiteral('\'');
            }
            case '\"': {
                return this.readStringLiteral('\"');
            }
            case 't': {
                return this.readBooleanLiteral();
            }
            case 'f': {
                return this.readBooleanLiteral();
            }
            case '-': {
                return this.readNumberLiteral();
            }
            case 'n': {
                return this.readNullLiteral();
            }
            case '{': {
                return this.readJsonLiteral();
            }
            case '[': {
                return this.readJsonLiteral();
            }
            case '/': {
                return this.readPattern();
            }
        }
        return this.readNumberLiteral();
    }

    private ExpressionNode readLogicalOR() {
        int n2;
        ArrayList<ExpressionNode> arrayList = new ArrayList<ExpressionNode>();
        arrayList.add(this.readLogicalAND());
        while (true) {
            n2 = this.filter.position();
            if (!this.filter.hasSignificantSubSequence(LogicalOperator.OR.getOperatorString())) break;
            arrayList.add(this.readLogicalAND());
        }
        this.filter.setPosition(n2);
        return 1 == arrayList.size() ? (ExpressionNode)arrayList.get(0) : LogicalExpressionNode.createLogicalOr(arrayList);
    }

    private ExpressionNode readLogicalAND() {
        int n2;
        ArrayList<ExpressionNode> arrayList = new ArrayList<ExpressionNode>();
        arrayList.add(this.readLogicalANDOperand());
        while (true) {
            n2 = this.filter.position();
            if (!this.filter.hasSignificantSubSequence(LogicalOperator.AND.getOperatorString())) break;
            arrayList.add(this.readLogicalANDOperand());
        }
        this.filter.setPosition(n2);
        return 1 == arrayList.size() ? (ExpressionNode)arrayList.get(0) : LogicalExpressionNode.createLogicalAnd(arrayList);
    }

    private ExpressionNode readLogicalANDOperand() {
        int n2 = this.filter.skipBlanks().position();
        if (this.filter.skipBlanks().currentCharIs('!')) {
            this.filter.readSignificantChar('!');
            switch (this.filter.skipBlanks().currentChar()) {
                case '$': 
                case '@': {
                    this.filter.setPosition(n2);
                    break;
                }
                default: {
                    ExpressionNode expressionNode = this.readLogicalANDOperand();
                    return LogicalExpressionNode.createLogicalNot(expressionNode);
                }
            }
        }
        if (this.filter.skipBlanks().currentCharIs('(')) {
            this.filter.readSignificantChar('(');
            ExpressionNode expressionNode = this.readLogicalOR();
            this.filter.readSignificantChar(')');
            return expressionNode;
        }
        return this.readExpression();
    }

    private RelationalExpressionNode readExpression() {
        ValueNode valueNode = this.readValueNode();
        int n2 = this.filter.position();
        try {
            RelationalOperator relationalOperator = this.readRelationalOperator();
            ValueNode valueNode2 = this.readValueNode();
            return new RelationalExpressionNode(valueNode, relationalOperator, valueNode2);
        }
        catch (InvalidPathException invalidPathException) {
            this.filter.setPosition(n2);
            ValueNodes$PathNode valueNodes$PathNode = valueNode.asPathNode();
            valueNode = valueNodes$PathNode.asExistsCheck(valueNodes$PathNode.shouldExists());
            RelationalOperator relationalOperator = RelationalOperator.EXISTS;
            ValueNodes$BooleanNode valueNodes$BooleanNode = valueNode.asPathNode().shouldExists() ? ValueNodes.TRUE : ValueNodes.FALSE;
            return new RelationalExpressionNode(valueNode, relationalOperator, valueNodes$BooleanNode);
        }
    }

    private LogicalOperator readLogicalOperator() {
        int n2 = this.filter.skipBlanks().position();
        int n3 = n2 + 1;
        if (!this.filter.inBounds(n3)) {
            throw new InvalidPathException("Expected boolean literal");
        }
        CharSequence charSequence = this.filter.subSequence(n2, n3 + 1);
        if (!charSequence.equals("||") && !charSequence.equals("&&")) {
            throw new InvalidPathException("Expected logical operator");
        }
        this.filter.incrementPosition(charSequence.length());
        logger.trace("LogicalOperator from {} to {} -> [{}]", new Object[]{n2, n3, charSequence});
        return LogicalOperator.fromString(charSequence.toString());
    }

    private RelationalOperator readRelationalOperator() {
        int n2 = this.filter.skipBlanks().position();
        if (this.isRelationalOperatorChar(this.filter.currentChar())) {
            while (this.filter.inBounds() && this.isRelationalOperatorChar(this.filter.currentChar())) {
                this.filter.incrementPosition(1);
            }
        } else {
            while (this.filter.inBounds() && this.filter.currentChar() != ' ') {
                this.filter.incrementPosition(1);
            }
        }
        CharSequence charSequence = this.filter.subSequence(n2, this.filter.position());
        logger.trace("Operator from {} to {} -> [{}]", new Object[]{n2, this.filter.position() - 1, charSequence});
        return RelationalOperator.fromString(charSequence.toString());
    }

    private ValueNodes.NullNode readNullLiteral() {
        CharSequence charSequence;
        int n2 = this.filter.position();
        if (this.filter.currentChar() == 'n' && this.filter.inBounds(this.filter.position() + 3) && "null".equals((charSequence = this.filter.subSequence(this.filter.position(), this.filter.position() + 4)).toString())) {
            logger.trace("NullLiteral from {} to {} -> [{}]", new Object[]{n2, this.filter.position() + 3, charSequence});
            this.filter.incrementPosition(charSequence.length());
            return ValueNode.createNullNode();
        }
        throw new InvalidPathException("Expected <null> value");
    }

    private ValueNodes$JsonNode readJsonLiteral() {
        int n2 = this.filter.position();
        char c2 = this.filter.currentChar();
        assert (c2 == '[' || c2 == '{');
        char c3 = c2 == '[' ? (char)']' : '}';
        int n3 = this.filter.indexOfMatchingCloseChar(this.filter.position(), c2, c3, true, false);
        if (n3 == -1) {
            throw new InvalidPathException("String not closed. Expected ' in " + this.filter);
        }
        this.filter.setPosition(n3 + 1);
        CharSequence charSequence = this.filter.subSequence(n2, this.filter.position());
        logger.trace("JsonLiteral from {} to {} -> [{}]", new Object[]{n2, this.filter.position(), charSequence});
        return ValueNode.createJsonNode(charSequence);
    }

    private int endOfFlags(int n2) {
        int n3 = n2;
        char[] cArray = new char[1];
        while (this.filter.inBounds(n3)) {
            cArray[0] = this.filter.charAt(n3);
            if (PatternFlag.parseFlags(cArray) <= 0) break;
            ++n3;
        }
        return n3;
    }

    private ValueNodes$PatternNode readPattern() {
        int n2;
        int n3 = this.filter.position();
        int n4 = this.filter.nextIndexOfUnescaped('/');
        if (n4 == -1) {
            throw new InvalidPathException("Pattern not closed. Expected / in " + this.filter);
        }
        if (this.filter.inBounds(n4 + 1) && (n2 = this.endOfFlags(n4 + 1)) > n4) {
            CharSequence charSequence = this.filter.subSequence(n4 + 1, n2);
            n4 += charSequence.length();
        }
        this.filter.setPosition(n4 + 1);
        CharSequence charSequence = this.filter.subSequence(n3, this.filter.position());
        logger.trace("PatternNode from {} to {} -> [{}]", new Object[]{n3, this.filter.position(), charSequence});
        return ValueNode.createPatternNode(charSequence);
    }

    private ValueNodes$StringNode readStringLiteral(char c2) {
        int n2 = this.filter.position();
        int n3 = this.filter.nextIndexOfUnescaped(c2);
        if (n3 == -1) {
            throw new InvalidPathException("String literal does not have matching quotes. Expected " + c2 + " in " + this.filter);
        }
        this.filter.setPosition(n3 + 1);
        CharSequence charSequence = this.filter.subSequence(n2, this.filter.position());
        logger.trace("StringLiteral from {} to {} -> [{}]", new Object[]{n2, this.filter.position(), charSequence});
        return ValueNode.createStringNode(charSequence, true);
    }

    private ValueNodes$NumberNode readNumberLiteral() {
        int n2 = this.filter.position();
        while (this.filter.inBounds() && this.filter.isNumberCharacter(this.filter.position())) {
            this.filter.incrementPosition(1);
        }
        CharSequence charSequence = this.filter.subSequence(n2, this.filter.position());
        logger.trace("NumberLiteral from {} to {} -> [{}]", new Object[]{n2, this.filter.position(), charSequence});
        return ValueNode.createNumberNode(charSequence);
    }

    private ValueNodes$BooleanNode readBooleanLiteral() {
        int n2;
        int n3 = this.filter.position();
        int n4 = n2 = this.filter.currentChar() == 't' ? this.filter.position() + 3 : this.filter.position() + 4;
        if (!this.filter.inBounds(n2)) {
            throw new InvalidPathException("Expected boolean literal");
        }
        CharSequence charSequence = this.filter.subSequence(n3, n2 + 1);
        if (!charSequence.equals("true") && !charSequence.equals("false")) {
            throw new InvalidPathException("Expected boolean literal");
        }
        this.filter.incrementPosition(charSequence.length());
        logger.trace("BooleanLiteral from {} to {} -> [{}]", new Object[]{n3, n2, charSequence});
        return ValueNode.createBooleanNode(charSequence);
    }

    private ValueNodes$PathNode readPath() {
        int n2;
        char c2 = this.filter.previousSignificantChar();
        int n3 = this.filter.position();
        this.filter.incrementPosition(1);
        while (this.filter.inBounds()) {
            boolean bl2;
            if (this.filter.currentChar() == '[') {
                n2 = this.filter.indexOfMatchingCloseChar(this.filter.position(), '[', ']', true, false);
                if (n2 == -1) {
                    throw new InvalidPathException("Square brackets does not match in filter " + this.filter);
                }
                this.filter.setPosition(n2 + 1);
            }
            n2 = this.filter.currentChar() == ')' && this.currentCharIsClosingFunctionBracket(n3) ? 1 : 0;
            boolean bl3 = bl2 = this.filter.currentChar() == ')' && n2 == 0;
            if (!this.filter.inBounds() || this.isRelationalOperatorChar(this.filter.currentChar()) || this.filter.currentChar() == ' ' || bl2) break;
            this.filter.incrementPosition(1);
        }
        n2 = c2 != '!' ? 1 : 0;
        CharSequence charSequence = this.filter.subSequence(n3, this.filter.position());
        return ValueNode.createPathNode(charSequence, false, n2 != 0);
    }

    private boolean expressionIsTerminated() {
        char c2 = this.filter.currentChar();
        if (c2 == ')' || this.isLogicalOperatorChar(c2)) {
            return true;
        }
        c2 = this.filter.nextSignificantChar();
        return c2 == ')' || this.isLogicalOperatorChar(c2);
    }

    private boolean currentCharIsClosingFunctionBracket(int n2) {
        if (this.filter.currentChar() != ')') {
            return false;
        }
        int n3 = this.filter.indexOfPreviousSignificantChar();
        if (n3 == -1 || this.filter.charAt(n3) != '(') {
            return false;
        }
        --n3;
        while (this.filter.inBounds(n3) && n3 > n2) {
            if (this.filter.charAt(n3) == '.') {
                return true;
            }
            --n3;
        }
        return false;
    }

    private boolean isLogicalOperatorChar(char c2) {
        return c2 == '&' || c2 == '|';
    }

    private boolean isRelationalOperatorChar(char c2) {
        return c2 == '<' || c2 == '>' || c2 == '=' || c2 == '~' || c2 == '!';
    }
}

