/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import java.io.DataOutput;
import java.io.OutputStream;

public final class LinkedBuffer {
    public static final int MIN_BUFFER_SIZE = 256;
    public static final int DEFAULT_BUFFER_SIZE = 512;
    final byte[] buffer;
    final int start;
    int offset;
    LinkedBuffer next;

    public static LinkedBuffer allocate() {
        return new LinkedBuffer(512);
    }

    public static LinkedBuffer allocate(int n2) {
        if (n2 < 256) {
            throw new IllegalArgumentException("256 is the minimum buffer size.");
        }
        return new LinkedBuffer(n2);
    }

    public static LinkedBuffer allocate(int n2, LinkedBuffer linkedBuffer) {
        if (n2 < 256) {
            throw new IllegalArgumentException("256 is the minimum buffer size.");
        }
        return new LinkedBuffer(n2, linkedBuffer);
    }

    public static LinkedBuffer wrap(byte[] byArray, int n2, int n3) {
        return new LinkedBuffer(byArray, n2, n2 + n3);
    }

    public static LinkedBuffer use(byte[] byArray) {
        return LinkedBuffer.use(byArray, 0);
    }

    public static LinkedBuffer use(byte[] byArray, int n2) {
        assert (n2 >= 0);
        if (byArray.length - n2 < 256) {
            throw new IllegalArgumentException("256 is the minimum buffer size.");
        }
        return new LinkedBuffer(byArray, n2, n2);
    }

    public static int writeTo(OutputStream outputStream, LinkedBuffer linkedBuffer) {
        int n2 = 0;
        do {
            int n3;
            if ((n3 = linkedBuffer.offset - linkedBuffer.start) <= 0) continue;
            outputStream.write(linkedBuffer.buffer, linkedBuffer.start, n3);
            n2 += n3;
        } while ((linkedBuffer = linkedBuffer.next) != null);
        return n2;
    }

    public static int writeTo(DataOutput dataOutput, LinkedBuffer linkedBuffer) {
        int n2 = 0;
        do {
            int n3;
            if ((n3 = linkedBuffer.offset - linkedBuffer.start) <= 0) continue;
            dataOutput.write(linkedBuffer.buffer, linkedBuffer.start, n3);
            n2 += n3;
        } while ((linkedBuffer = linkedBuffer.next) != null);
        return n2;
    }

    LinkedBuffer(int n2) {
        this(new byte[n2], 0, 0);
    }

    LinkedBuffer(int n2, LinkedBuffer linkedBuffer) {
        this(new byte[n2], 0, 0, linkedBuffer);
    }

    LinkedBuffer(byte[] byArray, int n2) {
        this(byArray, n2, n2);
    }

    LinkedBuffer(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.start = n2;
        this.offset = n3;
    }

    LinkedBuffer(byte[] byArray, int n2, LinkedBuffer linkedBuffer) {
        this(byArray, n2, n2);
        linkedBuffer.next = this;
    }

    LinkedBuffer(byte[] byArray, int n2, int n3, LinkedBuffer linkedBuffer) {
        this(byArray, n2, n3);
        linkedBuffer.next = this;
    }

    LinkedBuffer(LinkedBuffer linkedBuffer, LinkedBuffer linkedBuffer2) {
        this.buffer = linkedBuffer.buffer;
        this.offset = this.start = linkedBuffer.offset;
        linkedBuffer2.next = this;
    }

    public LinkedBuffer clear() {
        this.next = null;
        this.offset = this.start;
        return this;
    }
}

