/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import ia.sh.org.apache.commons.math3.distribution.ZipfDistribution$ZipfRejectionInversionSampler;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class ZipfDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -140627372283420404L;
    private final int numberOfElements;
    private final double exponent;
    private double numericalMean = Double.NaN;
    private boolean numericalMeanIsCalculated = false;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;
    private transient ZipfDistribution$ZipfRejectionInversionSampler sampler;

    public ZipfDistribution(int n2, double d2) {
        this(new Well19937c(), n2, d2);
    }

    public ZipfDistribution(RandomGenerator randomGenerator, int n2, double d2) {
        super(randomGenerator);
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n2);
        }
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.EXPONENT, d2);
        }
        this.numberOfElements = n2;
        this.exponent = d2;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    public double probability(int n2) {
        if (n2 <= 0 || n2 > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / FastMath.pow((double)n2, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    public double logProbability(int n2) {
        if (n2 <= 0 || n2 > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -FastMath.log(n2) * this.exponent - FastMath.log(this.generalizedHarmonic(this.numberOfElements, this.exponent));
    }

    public double cumulativeProbability(int n2) {
        if (n2 <= 0) {
            return 0.0;
        }
        if (n2 >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(n2, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    public double getNumericalMean() {
        if (!this.numericalMeanIsCalculated) {
            this.numericalMean = this.calculateNumericalMean();
            this.numericalMeanIsCalculated = true;
        }
        return this.numericalMean;
    }

    protected double calculateNumericalMean() {
        int n2 = this.getNumberOfElements();
        double d2 = this.getExponent();
        double d3 = this.generalizedHarmonic(n2, d2 - 1.0);
        double d4 = this.generalizedHarmonic(n2, d2);
        return d3 / d4;
    }

    public double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        int n2 = this.getNumberOfElements();
        double d2 = this.getExponent();
        double d3 = this.generalizedHarmonic(n2, d2 - 2.0);
        double d4 = this.generalizedHarmonic(n2, d2 - 1.0);
        double d5 = this.generalizedHarmonic(n2, d2);
        return d3 / d5 - d4 * d4 / (d5 * d5);
    }

    private double generalizedHarmonic(int n2, double d2) {
        double d3 = 0.0;
        for (int i2 = n2; i2 > 0; --i2) {
            d3 += 1.0 / FastMath.pow((double)i2, d2);
        }
        return d3;
    }

    public int getSupportLowerBound() {
        return 1;
    }

    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        if (this.sampler == null) {
            this.sampler = new ZipfDistribution$ZipfRejectionInversionSampler(this.numberOfElements, this.exponent);
        }
        return this.sampler.sample(this.random);
    }
}

