/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath;

import ia.sh.com.jayway.jsonpath.Configuration$1;
import ia.sh.com.jayway.jsonpath.Configuration$ConfigurationBuilder;
import ia.sh.com.jayway.jsonpath.Configuration$Defaults;
import ia.sh.com.jayway.jsonpath.EvaluationListener;
import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.internal.DefaultsImpl;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.spi.json.JsonProvider;
import ia.sh.com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class Configuration {
    private static Configuration$Defaults DEFAULTS = null;
    private final JsonProvider jsonProvider;
    private final MappingProvider mappingProvider;
    private final Set options;
    private final Collection evaluationListeners;

    public static synchronized void setDefaults(Configuration$Defaults configuration$Defaults) {
        DEFAULTS = configuration$Defaults;
    }

    private static Configuration$Defaults getEffectiveDefaults() {
        if (DEFAULTS == null) {
            return DefaultsImpl.INSTANCE;
        }
        return DEFAULTS;
    }

    private Configuration(JsonProvider jsonProvider, MappingProvider mappingProvider, EnumSet enumSet, Collection collection) {
        Utils.notNull(jsonProvider, "jsonProvider can not be null");
        Utils.notNull(mappingProvider, "mappingProvider can not be null");
        Utils.notNull(enumSet, "setOptions can not be null");
        Utils.notNull(collection, "evaluationListeners can not be null");
        this.jsonProvider = jsonProvider;
        this.mappingProvider = mappingProvider;
        this.options = Collections.unmodifiableSet(enumSet);
        this.evaluationListeners = Collections.unmodifiableCollection(collection);
    }

    public Configuration addEvaluationListeners(EvaluationListener ... evaluationListenerArray) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(this.options).evaluationListener(evaluationListenerArray).build();
    }

    public Configuration setEvaluationListeners(EvaluationListener ... evaluationListenerArray) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(this.options).evaluationListener(evaluationListenerArray).build();
    }

    public Collection getEvaluationListeners() {
        return this.evaluationListeners;
    }

    public Configuration jsonProvider(JsonProvider jsonProvider) {
        return Configuration.builder().jsonProvider(jsonProvider).mappingProvider(this.mappingProvider).options(this.options).evaluationListener(this.evaluationListeners).build();
    }

    public JsonProvider jsonProvider() {
        return this.jsonProvider;
    }

    public Configuration mappingProvider(MappingProvider mappingProvider) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(mappingProvider).options(this.options).evaluationListener(this.evaluationListeners).build();
    }

    public MappingProvider mappingProvider() {
        return this.mappingProvider;
    }

    public Configuration addOptions(Option ... optionArray) {
        EnumSet<Option> enumSet = EnumSet.noneOf(Option.class);
        enumSet.addAll(this.options);
        enumSet.addAll(Arrays.asList(optionArray));
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(enumSet).evaluationListener(this.evaluationListeners).build();
    }

    public Configuration setOptions(Option ... optionArray) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(optionArray).evaluationListener(this.evaluationListeners).build();
    }

    public Set getOptions() {
        return this.options;
    }

    public boolean containsOption(Option option) {
        return this.options.contains((Object)option);
    }

    public static Configuration defaultConfiguration() {
        Configuration$Defaults configuration$Defaults = Configuration.getEffectiveDefaults();
        return Configuration.builder().jsonProvider(configuration$Defaults.jsonProvider()).options(configuration$Defaults.options()).build();
    }

    public static Configuration$ConfigurationBuilder builder() {
        return new Configuration$ConfigurationBuilder();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Configuration configuration = (Configuration)object;
        return this.jsonProvider.getClass() == configuration.jsonProvider.getClass() && this.mappingProvider.getClass() == configuration.mappingProvider.getClass() && Objects.equals(this.options, configuration.options);
    }

    static /* synthetic */ Configuration$Defaults access$000() {
        return Configuration.getEffectiveDefaults();
    }

    /* synthetic */ Configuration(JsonProvider jsonProvider, MappingProvider mappingProvider, EnumSet enumSet, Collection collection, Configuration$1 configuration$1) {
        this(jsonProvider, mappingProvider, enumSet, collection);
    }
}

