/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import ia.sh.com.jayway.jsonpath.internal.path.PathToken;
import ia.sh.com.jayway.jsonpath.internal.path.PredicateContextImpl;
import java.util.Collection;
import java.util.Collections;

public class PredicatePathToken
extends PathToken {
    private final Collection predicates;

    PredicatePathToken(Predicate predicate) {
        this.predicates = Collections.singletonList(predicate);
    }

    PredicatePathToken(Collection collection) {
        this.predicates = collection;
    }

    @Override
    public void evaluate(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        if (evaluationContextImpl.jsonProvider().isMap(object)) {
            if (this.accept(object, evaluationContextImpl.rootDocument(), evaluationContextImpl.configuration(), evaluationContextImpl)) {
                PathRef pathRef2;
                PathRef pathRef3 = pathRef2 = evaluationContextImpl.forUpdate() ? pathRef : PathRef.NO_OP;
                if (this.isLeaf()) {
                    evaluationContextImpl.addResult(string, pathRef2, object);
                } else {
                    this.next().evaluate(string, pathRef2, object, evaluationContextImpl);
                }
            }
        } else if (evaluationContextImpl.jsonProvider().isArray(object)) {
            int n2 = 0;
            Iterable iterable = evaluationContextImpl.jsonProvider().toIterable(object);
            for (Object t2 : iterable) {
                if (this.accept(t2, evaluationContextImpl.rootDocument(), evaluationContextImpl.configuration(), evaluationContextImpl)) {
                    this.handleArrayIndex(n2, string, object, evaluationContextImpl);
                }
                ++n2;
            }
        } else if (this.isUpstreamDefinite()) {
            throw new InvalidPathException(String.format("Filter: %s can not be applied to primitives. Current context is: %s", this.toString(), object));
        }
    }

    public boolean accept(Object object, Object object2, Configuration configuration, EvaluationContextImpl evaluationContextImpl) {
        PredicateContextImpl predicateContextImpl = new PredicateContextImpl(object, object2, configuration, evaluationContextImpl.documentEvalCache());
        for (Predicate predicate : this.predicates) {
            try {
                if (predicate.apply(predicateContextImpl)) continue;
                return false;
            }
            catch (InvalidPathException invalidPathException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getPathFragment() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i2 = 0; i2 < this.predicates.size(); ++i2) {
            if (i2 != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("?");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }
}

