/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractRealDistribution;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.special.Beta;
import ia.sh.org.apache.commons.math3.special.Gamma;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class TDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -5852615386664158222L;
    private final double degreesOfFreedom;
    private final double solverAbsoluteAccuracy;
    private final double factor;

    public TDistribution(double d2) {
        this(d2, 1.0E-9);
    }

    public TDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public TDistribution(RandomGenerator randomGenerator, double d2) {
        this(randomGenerator, d2, 1.0E-9);
    }

    public TDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d2);
        }
        this.degreesOfFreedom = d2;
        this.solverAbsoluteAccuracy = d3;
        double d4 = d2;
        double d5 = (d4 + 1.0) / 2.0;
        this.factor = Gamma.logGamma(d5) - 0.5 * (FastMath.log(Math.PI) + FastMath.log(d4)) - Gamma.logGamma(d4 / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public double density(double d2) {
        return FastMath.exp(this.logDensity(d2));
    }

    public double logDensity(double d2) {
        double d3 = this.degreesOfFreedom;
        double d4 = (d3 + 1.0) / 2.0;
        return this.factor - d4 * FastMath.log(1.0 + d2 * d2 / d3);
    }

    public double cumulativeProbability(double d2) {
        double d3;
        if (d2 == 0.0) {
            d3 = 0.5;
        } else {
            double d4 = Beta.regularizedBeta(this.degreesOfFreedom / (this.degreesOfFreedom + d2 * d2), 0.5 * this.degreesOfFreedom, 0.5);
            d3 = d2 < 0.0 ? 0.5 * d4 : 1.0 - 0.5 * d4;
        }
        return d3;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        double d2 = this.getDegreesOfFreedom();
        if (d2 > 1.0) {
            return 0.0;
        }
        return Double.NaN;
    }

    public double getNumericalVariance() {
        double d2 = this.getDegreesOfFreedom();
        if (d2 > 2.0) {
            return d2 / (d2 - 2.0);
        }
        if (d2 > 1.0 && d2 <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

