/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.net.minidev.json;

import ia.sh.net.minidev.json.JSONStyle;
import ia.sh.net.minidev.json.parser.JSONParser;
import ia.sh.net.minidev.json.parser.ParseException;
import ia.sh.net.minidev.json.reader.JsonWriter;
import ia.sh.net.minidev.json.reader.JsonWriterI;
import ia.sh.net.minidev.json.writer.CompessorMapper;
import ia.sh.net.minidev.json.writer.FakeMapper;
import ia.sh.net.minidev.json.writer.JsonReader;
import ia.sh.net.minidev.json.writer.JsonReaderI;
import ia.sh.net.minidev.json.writer.UpdaterMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    public static final JsonWriter defaultWriter = new JsonWriter();
    public static final JsonReader defaultReader = new JsonReader();

    public static Object parse(InputStream inputStream) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(byte[] byArray) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(InputStream inputStream, Class clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(inputStream, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(Reader reader) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(byte[] byArray, Class clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(byArray, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(Reader reader, Class clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(reader, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(Reader reader, Object object) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(reader, (JsonReaderI)new UpdaterMapper(defaultReader, object));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Object parse(Reader reader, JsonReaderI jsonReaderI) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(reader, jsonReaderI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(String string, Class clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(string, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(InputStream inputStream, Object object) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(inputStream, (JsonReaderI)new UpdaterMapper(defaultReader, object));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(String string, Object object) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(string, (JsonReaderI)new UpdaterMapper(defaultReader, object));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Object parse(byte[] byArray, JsonReaderI jsonReaderI) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(byArray, jsonReaderI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Object parse(String string, JsonReaderI jsonReaderI) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(string, jsonReaderI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(String string) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader reader) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, JSONValue.defaultReader.DEFAULT_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String string) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, JSONValue.defaultReader.DEFAULT_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String compress(String string, JSONStyle jSONStyle) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, (JsonReaderI)new CompessorMapper(defaultReader, stringBuilder, jSONStyle));
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String compress(String string) {
        return JSONValue.compress(string, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String string) {
        return JSONValue.compress(string, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] byArray) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(InputStream inputStream) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(Reader reader) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(String string) {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(String string, Class clazz) {
        JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        return jSONParser.parse(string, defaultReader.getMapper(clazz));
    }

    public static Object parseStrict(Reader reader) {
        return new JSONParser(656).parse(reader, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseStrict(String string) {
        return new JSONParser(656).parse(string, JSONValue.defaultReader.DEFAULT);
    }

    public static boolean isValidJsonStrict(Reader reader) {
        try {
            new JSONParser(656).parse(reader, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String string) {
        try {
            new JSONParser(656).parse(string, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJson(Reader reader) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJson(String string) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static void writeJSONString(Object object, Appendable appendable) {
        JSONValue.writeJSONString(object, appendable, COMPRESSION);
    }

    public static void remapField(Class clazz, String string, String string2) {
        defaultReader.remapField(clazz, string, string2);
        defaultWriter.remapField(clazz, string2, string);
    }

    public static void registerWriter(Class clazz, JsonWriterI jsonWriterI) {
        defaultWriter.registerWriter(jsonWriterI, clazz);
    }

    public static void registerReader(Class clazz, JsonReaderI jsonReaderI) {
        defaultReader.registerReader(clazz, jsonReaderI);
    }

    public static void writeJSONString(Object object, Appendable appendable, JSONStyle jSONStyle) {
        if (object == null) {
            appendable.append("null");
            return;
        }
        Class<?> clazz = object.getClass();
        JsonWriterI jsonWriterI = defaultWriter.getWrite(clazz);
        if (jsonWriterI == null) {
            if (clazz.isArray()) {
                jsonWriterI = JsonWriter.arrayWriter;
            } else {
                jsonWriterI = defaultWriter.getWriterByInterface(object.getClass());
                if (jsonWriterI == null) {
                    jsonWriterI = JsonWriter.beansWriterASM;
                }
            }
            defaultWriter.registerWriter(jsonWriterI, clazz);
        }
        jsonWriterI.writeJSONString(object, appendable, jSONStyle);
    }

    public static String toJSONString(Object object) {
        return JSONValue.toJSONString(object, COMPRESSION);
    }

    public static String toJSONString(Object object, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONValue.writeJSONString(object, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        return JSONValue.escape(string, COMPRESSION);
    }

    public static String escape(String string, JSONStyle jSONStyle) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        jSONStyle.escape(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(String string, Appendable appendable) {
        JSONValue.escape(string, appendable, COMPRESSION);
    }

    public static void escape(String string, Appendable appendable, JSONStyle jSONStyle) {
        if (string == null) {
            return;
        }
        jSONStyle.escape(string, appendable);
    }
}

