/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.exception.MathArithmeticException;
import ia.sh.org.apache.commons.math3.exception.NotPositiveException;
import ia.sh.org.apache.commons.math3.exception.NumberIsTooLargeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.util.ArithmeticUtils;
import ia.sh.org.apache.commons.math3.util.Combinations;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public final class CombinatoricsUtils {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final AtomicReference STIRLING_S2 = new AtomicReference<Object>(null);

    private CombinatoricsUtils() {
    }

    public static long binomialCoefficient(int n2, int n3) {
        CombinatoricsUtils.checkBinomial(n2, n3);
        if (n2 == n3 || n3 == 0) {
            return 1L;
        }
        if (n3 == 1 || n3 == n2 - 1) {
            return n2;
        }
        if (n3 > n2 / 2) {
            return CombinatoricsUtils.binomialCoefficient(n2, n2 - n3);
        }
        long l2 = 1L;
        if (n2 <= 61) {
            int n4 = n2 - n3 + 1;
            for (int i2 = 1; i2 <= n3; ++i2) {
                l2 = l2 * (long)n4 / (long)i2;
                ++n4;
            }
        } else if (n2 <= 66) {
            int n5 = n2 - n3 + 1;
            for (int i3 = 1; i3 <= n3; ++i3) {
                long l3 = ArithmeticUtils.gcd(n5, i3);
                l2 = l2 / ((long)i3 / l3) * ((long)n5 / l3);
                ++n5;
            }
        } else {
            int n6 = n2 - n3 + 1;
            for (int i4 = 1; i4 <= n3; ++i4) {
                long l4 = ArithmeticUtils.gcd(n6, i4);
                l2 = ArithmeticUtils.mulAndCheck(l2 / ((long)i4 / l4), (long)n6 / l4);
                ++n6;
            }
        }
        return l2;
    }

    public static double binomialCoefficientDouble(int n2, int n3) {
        CombinatoricsUtils.checkBinomial(n2, n3);
        if (n2 == n3 || n3 == 0) {
            return 1.0;
        }
        if (n3 == 1 || n3 == n2 - 1) {
            return n2;
        }
        if (n3 > n2 / 2) {
            return CombinatoricsUtils.binomialCoefficientDouble(n2, n2 - n3);
        }
        if (n2 < 67) {
            return CombinatoricsUtils.binomialCoefficient(n2, n3);
        }
        double d2 = 1.0;
        for (int i2 = 1; i2 <= n3; ++i2) {
            d2 *= (double)(n2 - n3 + i2) / (double)i2;
        }
        return FastMath.floor(d2 + 0.5);
    }

    public static double binomialCoefficientLog(int n2, int n3) {
        int n4;
        CombinatoricsUtils.checkBinomial(n2, n3);
        if (n2 == n3 || n3 == 0) {
            return 0.0;
        }
        if (n3 == 1 || n3 == n2 - 1) {
            return FastMath.log(n2);
        }
        if (n2 < 67) {
            return FastMath.log(CombinatoricsUtils.binomialCoefficient(n2, n3));
        }
        if (n2 < 1030) {
            return FastMath.log(CombinatoricsUtils.binomialCoefficientDouble(n2, n3));
        }
        if (n3 > n2 / 2) {
            return CombinatoricsUtils.binomialCoefficientLog(n2, n2 - n3);
        }
        double d2 = 0.0;
        for (n4 = n2 - n3 + 1; n4 <= n2; ++n4) {
            d2 += FastMath.log(n4);
        }
        for (n4 = 2; n4 <= n3; ++n4) {
            d2 -= FastMath.log(n4);
        }
        return d2;
    }

    public static long factorial(int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 > 20) {
            throw new MathArithmeticException();
        }
        return FACTORIALS[n2];
    }

    public static double factorialDouble(int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FACTORIALS[n2];
        }
        return FastMath.floor(FastMath.exp(CombinatoricsUtils.factorialLog(n2)) + 0.5);
    }

    public static double factorialLog(int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FastMath.log(FACTORIALS[n2]);
        }
        double d2 = 0.0;
        for (int i2 = 2; i2 <= n2; ++i2) {
            d2 += FastMath.log(i2);
        }
        return d2;
    }

    public static long stirlingS2(int n2, int n3) {
        if (n3 < 0) {
            throw new NotPositiveException(n3);
        }
        if (n3 > n2) {
            throw new NumberIsTooLargeException(n3, (Number)n2, true);
        }
        Object object = (long[][])STIRLING_S2.get();
        if (object == null) {
            int n4 = 26;
            object = new long[26][];
            object[0] = new long[]{1L};
            for (int i2 = 1; i2 < ((long[][])object).length; ++i2) {
                object[i2] = new long[i2 + 1];
                object[i2][0] = 0L;
                object[i2][1] = 1L;
                object[i2][i2] = 1L;
                for (int i3 = 2; i3 < i2; ++i3) {
                    object[i2][i3] = (long)i3 * object[i2 - 1][i3] + object[i2 - 1][i3 - 1];
                }
            }
            STIRLING_S2.compareAndSet(null, object);
        }
        if (n2 < ((long[][])object).length) {
            return object[n2][n3];
        }
        if (n3 == 0) {
            return 0L;
        }
        if (n3 == 1 || n3 == n2) {
            return 1L;
        }
        if (n3 == 2) {
            return (1L << n2 - 1) - 1L;
        }
        if (n3 == n2 - 1) {
            return CombinatoricsUtils.binomialCoefficient(n2, 2);
        }
        long l2 = 0L;
        long l3 = (n3 & 1) == 0 ? 1L : -1L;
        for (int i4 = 1; i4 <= n3; ++i4) {
            if ((l2 += (l3 = -l3) * CombinatoricsUtils.binomialCoefficient(n3, i4) * (long)ArithmeticUtils.pow(i4, n2)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n2, 0, ((long[][])object).length - 1);
        }
        return l2 / CombinatoricsUtils.factorial(n3);
    }

    public static Iterator combinationsIterator(int n2, int n3) {
        return new Combinations(n2, n3).iterator();
    }

    public static void checkBinomial(int n2, int n3) {
        if (n2 < n3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, (Number)n3, n2, true);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n2);
        }
    }
}

