/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.fastinv;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class FastInv
implements InventoryHolder {
    private final Map<Integer, Consumer<InventoryClickEvent>> itemHandlers = new HashMap<Integer, Consumer<InventoryClickEvent>>();
    private Set<Consumer<InventoryOpenEvent>> openHandlers;
    private Set<Consumer<InventoryCloseEvent>> closeHandlers;
    private Set<Consumer<InventoryClickEvent>> clickHandlers;
    private Predicate<Player> closeFilter;
    private Inventory inventory;

    public FastInv(int size) {
        this(size, InventoryType.CHEST.getDefaultTitle());
    }

    public FastInv(int size, String title) {
        this(size, InventoryType.CHEST, title);
    }

    public FastInv(InventoryType type) {
        this(type, type.getDefaultTitle());
    }

    public FastInv(InventoryType type, String title) {
        this(0, type, title);
    }

    private FastInv(int size, InventoryType type, String title) {
        this.inventory = type == InventoryType.CHEST && size > 0 ? Bukkit.createInventory((InventoryHolder)this, (int)size, (String)title) : Bukkit.createInventory((InventoryHolder)this, (InventoryType)Objects.requireNonNull(type, "type"), (String)title);
        if (this.inventory.getHolder() != this) {
            throw new IllegalStateException("Inventory holder is not FastInv, found: " + this.inventory.getHolder());
        }
    }

    protected void onOpen(InventoryOpenEvent event) {
    }

    protected void onClick(InventoryClickEvent event) {
    }

    protected void onClose(InventoryCloseEvent event) {
    }

    public void addItem(ItemStack item) {
        this.addItem(item, null);
    }

    public void addItem(ItemStack item, Consumer<InventoryClickEvent> handler) {
        int slot = this.inventory.firstEmpty();
        if (slot >= 0) {
            this.setItem(slot, item, handler);
        }
    }

    public void setItem(int slot, ItemStack item) {
        this.setItem(slot, item, null);
    }

    public void setItem(int slot, ItemStack item, Consumer<InventoryClickEvent> handler) {
        this.inventory.setItem(slot, item);
        if (handler != null) {
            this.itemHandlers.put(slot, handler);
        } else {
            this.itemHandlers.remove(slot);
        }
    }

    public void setItems(int slotFrom, int slotTo, ItemStack item) {
        this.setItems(slotFrom, slotTo, item, null);
    }

    public void setItems(int slotFrom, int slotTo, ItemStack item, Consumer<InventoryClickEvent> handler) {
        for (int i = slotFrom; i <= slotTo; ++i) {
            this.setItem(i, item, handler);
        }
    }

    public void setItems(int[] slots, ItemStack item) {
        this.setItems(slots, item, null);
    }

    public void setItems(int[] slots, ItemStack item, Consumer<InventoryClickEvent> handler) {
        for (int slot : slots) {
            this.setItem(slot, item, handler);
        }
    }

    public void removeItem(int slot) {
        this.inventory.clear(slot);
        this.itemHandlers.remove(slot);
    }

    public void removeItems(int ... slots) {
        for (int slot : slots) {
            this.removeItem(slot);
        }
    }

    public void setCloseFilter(Predicate<Player> closeFilter) {
        this.closeFilter = closeFilter;
    }

    public void addOpenHandler(Consumer<InventoryOpenEvent> openHandler) {
        if (this.openHandlers == null) {
            this.openHandlers = new HashSet<Consumer<InventoryOpenEvent>>();
        }
        this.openHandlers.add(openHandler);
    }

    public void addCloseHandler(Consumer<InventoryCloseEvent> closeHandler) {
        if (this.closeHandlers == null) {
            this.closeHandlers = new HashSet<Consumer<InventoryCloseEvent>>();
        }
        this.closeHandlers.add(closeHandler);
    }

    public void addClickHandler(Consumer<InventoryClickEvent> clickHandler) {
        if (this.clickHandlers == null) {
            this.clickHandlers = new HashSet<Consumer<InventoryClickEvent>>();
        }
        this.clickHandlers.add(clickHandler);
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public int[] getBorders() {
        int size = this.inventory.getSize();
        return IntStream.range(0, size).filter(i -> size < 27 || i < 9 || i % 9 == 0 || (i - 8) % 9 == 0 || i > size - 9).toArray();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    void handleOpen(InventoryOpenEvent e) {
        this.onOpen(e);
        if (this.openHandlers != null) {
            this.openHandlers.forEach(c -> c.accept(e));
        }
    }

    boolean handleClose(InventoryCloseEvent e) {
        this.onClose(e);
        if (this.closeHandlers != null) {
            this.closeHandlers.forEach(c -> c.accept(e));
        }
        return this.closeFilter != null && this.closeFilter.test((Player)e.getPlayer());
    }

    void handleClick(InventoryClickEvent e) {
        Consumer<InventoryClickEvent> clickConsumer;
        this.onClick(e);
        if (this.clickHandlers != null) {
            this.clickHandlers.forEach(c -> c.accept(e));
        }
        if ((clickConsumer = this.itemHandlers.get(e.getRawSlot())) != null) {
            clickConsumer.accept(e);
        }
    }
}

