/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.random;

import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public abstract class BitsStreamGenerator
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 20130104L;
    private double nextGaussian = Double.NaN;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public double nextDouble() {
        long l2 = (long)this.next(26) << 26;
        int n2 = this.next(26);
        return (double)(l2 | (long)n2) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double d2;
        if (Double.isNaN(this.nextGaussian)) {
            double d3 = this.nextDouble();
            double d4 = this.nextDouble();
            double d5 = Math.PI * 2 * d3;
            double d6 = FastMath.sqrt(-2.0 * FastMath.log(d4));
            d2 = d6 * FastMath.cos(d5);
            this.nextGaussian = d6 * FastMath.sin(d5);
        } else {
            d2 = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return d2;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n2) {
        if (n2 > 0) {
            int n3;
            int n4;
            if ((n2 & -n2) == n2) {
                return (int)((long)n2 * (long)this.next(31) >> 31);
            }
            while ((n4 = this.next(31)) - (n3 = n4 % n2) + (n2 - 1) < 0) {
            }
            return n3;
        }
        throw new NotStrictlyPositiveException(n2);
    }

    public long nextLong() {
        long l2 = (long)this.next(32) << 32;
        long l3 = (long)this.next(32) & 0xFFFFFFFFL;
        return l2 | l3;
    }

    public long nextLong(long l2) {
        if (l2 > 0L) {
            long l3;
            long l4;
            do {
                l3 = (long)this.next(31) << 32;
            } while ((l3 |= (long)this.next(32) & 0xFFFFFFFFL) - (l4 = l3 % l2) + (l2 - 1L) < 0L);
            return l4;
        }
        throw new NotStrictlyPositiveException(l2);
    }

    public void clear() {
        this.nextGaussian = Double.NaN;
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytesFill(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new OutOfRangeException(n2, (Number)0, byArray.length);
        }
        if (n3 < 0 || n3 > byArray.length - n2) {
            throw new OutOfRangeException(n3, (Number)0, byArray.length - n2);
        }
        this.nextBytesFill(byArray, n2, n3);
    }

    private void nextBytesFill(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2;
        int n6 = n5 + (n3 & 0x7FFFFFFC);
        while (n5 < n6) {
            n4 = this.next(32);
            byArray[n5++] = (byte)n4;
            byArray[n5++] = (byte)(n4 >>> 8);
            byArray[n5++] = (byte)(n4 >>> 16);
            byArray[n5++] = (byte)(n4 >>> 24);
        }
        n4 = n2 + n3;
        if (n5 < n4) {
            int n7 = this.next(32);
            while (true) {
                byArray[n5++] = (byte)n7;
                if (n5 >= n4) break;
                n7 >>>= 8;
            }
        }
    }
}

