/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.exception.MathInternalError;
import ia.sh.org.apache.commons.math3.util.Combinations$IterationOrder;
import ia.sh.org.apache.commons.math3.util.Combinations$LexicographicComparator;
import ia.sh.org.apache.commons.math3.util.Combinations$LexicographicIterator;
import ia.sh.org.apache.commons.math3.util.Combinations$SingletonIterator;
import ia.sh.org.apache.commons.math3.util.CombinatoricsUtils;
import ia.sh.org.apache.commons.math3.util.MathArrays;
import java.util.Comparator;
import java.util.Iterator;

public class Combinations
implements Iterable {
    private final int n;
    private final int k;
    private final Combinations$IterationOrder iterationOrder;

    public Combinations(int n2, int n3) {
        this(n2, n3, Combinations$IterationOrder.LEXICOGRAPHIC);
    }

    private Combinations(int n2, int n3, Combinations$IterationOrder combinations$IterationOrder) {
        CombinatoricsUtils.checkBinomial(n2, n3);
        this.n = n2;
        this.k = n3;
        this.iterationOrder = combinations$IterationOrder;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public Iterator iterator() {
        if (this.k == 0 || this.k == this.n) {
            return new Combinations$SingletonIterator(MathArrays.natural(this.k));
        }
        switch (this.iterationOrder) {
            case LEXICOGRAPHIC: {
                return new Combinations$LexicographicIterator(this.n, this.k);
            }
        }
        throw new MathInternalError();
    }

    public Comparator comparator() {
        return new Combinations$LexicographicComparator(this.n, this.k);
    }
}

