/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeUtils;

public abstract class KingdomsCommand {
    protected static final Kingdoms plugin = Kingdoms.get();
    protected static final boolean COLORIZE_TAB_COMPLETES = XMaterial.supports(13);
    protected final @NonNull Permission permission;
    protected final @NonNull Permission bypassCooldownPermission;
    protected final @NonNull Permission bypassDisabledWorldsPermission;
    protected final @NonNull String name;
    protected final String[] path;
    protected final @Nullable KingdomsParentCommand parent;
    protected final @Nullable Messenger description;
    protected final @NonNull Set<String> disabledWorlds;
    protected final @NonNull Map<SupportedLanguage, List<String>> aliases;
    protected final long cooldown;
    private static final String PATTERN = "[a-zA-Z0-9]+";
    private static final Pattern COMMAND_NODE_PATTERN = Pattern.compile("[a-zA-Z0-9]+");

    public KingdomsCommand(@org.kingdoms.libs.intellij.lang.annotations.Pattern(value="[a-zA-Z0-9]+") @NonNull String name, @Nullable KingdomsParentCommand parent, PermissionDefault permissionDefault) {
        Objects.requireNonNull(name, "Command name cannot be null");
        if (!COMMAND_NODE_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Command name doesn't match patern: " + COMMAND_NODE_PATTERN.pattern());
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.parent = parent;
        String identifier = KingdomsCommand.calculatePermission(parent, this.name);
        this.path = ArrayUtils.merge(new String[]{"command"}, StringUtils.splitArray(identifier, '.'));
        this.description = this.lang("description");
        this.permission = new Permission("kingdoms.command." + identifier, this.description.parse(new Object[0]), permissionDefault == null ? (parent == null ? PermissionDefault.OP : parent.getPermission().getDefault()) : permissionDefault);
        this.bypassDisabledWorldsPermission = new Permission("kingdoms.command." + identifier + ".bypass.disabled-worlds", "Permission to use this command even when it's disabled in a certain world.");
        this.bypassCooldownPermission = new Permission("kingdoms.command." + identifier + ".bypass.cooldown", "Permission to bypass the command cooldown.");
        ConfigSection section = KingdomsConfig.COMMANDS.getSection().getSection().getSection(KingdomsCommand.calculateConfigEntry(identifier));
        if (section != null) {
            if (section.getBoolean("disabled")) {
                this.cooldown = 0L;
                this.disabledWorlds = new HashSet<String>();
                this.aliases = null;
                return;
            }
            this.aliases = new NonNullMap<SupportedLanguage, List<String>>(new QuickEnumMap((Enum[])SupportedLanguage.VALUES));
            String cd = section.getString("cooldown");
            this.cooldown = Strings.isNullOrEmpty((String)cd) ? 0L : Optional.ofNullable(TimeUtils.parseTime(cd, TimeUnit.SECONDS)).orElseThrow(() -> new IllegalArgumentException("Invalid time format for command cooldown " + this.name + ": " + cd));
            this.disabledWorlds = new HashSet<String>(section.getStringList("disabled-worlds"));
        } else {
            this.cooldown = 0L;
            this.aliases = new NonNullMap<SupportedLanguage, List<String>>(new QuickEnumMap((Enum[])SupportedLanguage.VALUES));
            this.disabledWorlds = new HashSet<String>();
        }
        if (this instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Kingdoms.get());
        }
        if (permissionDefault == null && parent != null) {
            this.permission.setDefault(parent.getPermission().getDefault());
        }
        Bukkit.getPluginManager().addPermission(this.permission);
        Bukkit.getPluginManager().addPermission(this.bypassCooldownPermission);
        Bukkit.getPluginManager().addPermission(this.bypassDisabledWorldsPermission);
        Map<SupportedLanguage, Map<String, KingdomsCommand>> map = parent == null ? KingdomsCommandHandler.COMMANDS : parent.children;
        for (SupportedLanguage lang : SupportedLanguage.getInstalled()) {
            Map cmdMap = map.computeIfAbsent(lang, k -> new HashMap(1));
            try {
                MessageObject aliasesObj = this.lang("aliases").getMessageObject(lang);
                String mainName = this.getDisplayName().getMessageObject(lang).buildPlain(MessageBuilder.DEFAULT);
                cmdMap.put(mainName.toLowerCase(lang.getLocale()), this);
                if (lang == SupportedLanguage.EN) {
                    cmdMap.put(name.toLowerCase(lang.getLocale()), this);
                }
                if (aliasesObj != null) {
                    String[] aliases = StringUtils.splitArray(aliasesObj.buildPlain(MessageBuilder.DEFAULT), ' ');
                    this.aliases.put(lang, Arrays.asList(aliases));
                    for (String alias : aliases) {
                        KingdomsCommand previous = cmdMap.put(alias.toLowerCase(lang.getLocale()), this);
                        if (previous == null) continue;
                        KLogger.warn("The alias '" + alias + "' for command '" + identifier + "' has overridden command '" + previous.name + '\'');
                    }
                    continue;
                }
                this.aliases.put(lang, Collections.emptyList());
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public Map<SupportedLanguage, List<String>> getAliases() {
        return Collections.unmodifiableMap(this.aliases);
    }

    public void setPermissionDefault(PermissionDefault permissionDefault) {
        this.permission.setDefault(permissionDefault);
    }

    public KingdomsCommand(@NonNull String name) {
        this(name, false);
    }

    public KingdomsCommand(@NonNull String name, boolean playersCmd) {
        this(name, null, (PermissionDefault)(playersCmd ? PermissionDefault.TRUE : null));
    }

    public KingdomsCommand(@org.kingdoms.libs.intellij.lang.annotations.Pattern(value="[a-zA-Z0-9]+") @NonNull String name, KingdomsParentCommand parent) {
        this(name, parent, null);
    }

    public void unregisterPermissions() {
        for (Permission perm : Arrays.asList(this.permission, this.bypassCooldownPermission, this.bypassDisabledWorldsPermission)) {
            Bukkit.getPluginManager().removePermission(perm);
        }
    }

    private static String[] calculateConfigEntry(String nameEntry) {
        return ConfigPath.buildRaw(StringUtils.replace(nameEntry, '.', ".commands.").toString());
    }

    public static String joinArgs(String[] args) {
        return String.join((CharSequence)" ", args);
    }

    public static String joinArgs(String[] args, int from) {
        return Arrays.stream(args).skip(from).collect(Collectors.joining(" "));
    }

    public boolean canBypassDisabledWorlds(CommandSender sender) {
        return sender.hasPermission(this.bypassDisabledWorldsPermission);
    }

    public boolean canBypassCooldown(CommandSender sender) {
        return sender.hasPermission(this.bypassCooldownPermission);
    }

    private static String processTabMessage(String str) {
        return COLORIZE_TAB_COMPLETES ? MessageHandler.colorize(str) : MessageHandler.stripColors(MessageHandler.colorize(str), true);
    }

    public static List<String> tabComplete(String completion) {
        return Collections.singletonList(KingdomsCommand.processTabMessage(completion));
    }

    public static List<String> tabComplete(String ... completions) {
        for (int i = 0; i < completions.length; ++i) {
            completions[i] = KingdomsCommand.processTabMessage(completions[i]);
        }
        return Arrays.asList(completions);
    }

    public Messenger getUsage() {
        return this.lang("usage");
    }

    public static List<String> tabComplete(Collection<String> completions) {
        ArrayList<String> tabs = new ArrayList<String>(completions.size());
        for (String str : completions) {
            tabs.add(KingdomsCommand.processTabMessage(str));
        }
        return tabs;
    }

    protected static OfflinePlayer getPlayer(CommandSender sender, String name) {
        OfflinePlayer player = PlayerUtils.getOfflinePlayer(name);
        if (player == null) {
            KingdomsLang.NOT_FOUND_PLAYER.sendError(sender, new Object[0]);
        }
        return player;
    }

    protected static List<String> emptyTab() {
        return Collections.emptyList();
    }

    public static Boolean parseBool(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.toLowerCase(Locale.ENGLISH)).equals("true") || str.equals("t") || str.equals("y")) {
            return true;
        }
        if (str.equals("false") || str.equals("f") || str.equals("n")) {
            return false;
        }
        return null;
    }

    public @NonNull Set<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    private static String calculatePermission(KingdomsParentCommand parent, String name) {
        KingdomsParentCommand lastGroup = parent;
        StringBuilder perms = new StringBuilder(50);
        while (lastGroup != null) {
            perms.insert(0, lastGroup.name + '.');
            lastGroup = lastGroup.parent;
        }
        return perms.append(name).toString();
    }

    protected boolean isDisabled() {
        return this.aliases == null;
    }

    public @NonNull Permission getPermission() {
        return this.permission;
    }

    public boolean hasPermission(@NonNull CommandSender sender) {
        return sender.hasPermission(this.permission);
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (sender.hasPermission(perm)) {
            return true;
        }
        return sender instanceof Player && KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender)).isAdmin();
    }

    public String toString() {
        KingdomsParentCommand lastGroupChk = this.parent;
        StringBuilder command = new StringBuilder(this.name);
        while (lastGroupChk != null) {
            command.insert(0, lastGroupChk.name + ' ');
            lastGroupChk = lastGroupChk.parent;
        }
        return command.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomsCommand)) {
            return false;
        }
        KingdomsCommand cmd = (KingdomsCommand)obj;
        return this.name.equals(cmd.name) && this.parent == cmd.parent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + this.name.hashCode();
        result = prime * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    protected Messenger lang(String ... path) {
        return new LanguageEntryMessenger(ArrayUtils.merge(this.path, path));
    }

    public void execute(CommandContext context) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public CommandResult executeX(@NonNull CommandContext context) {
        return CommandResult.NOT_IMPLEMENTED;
    }

    @Deprecated
    public List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        return null;
    }

    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return new ArrayList<String>();
    }

    public final @NonNull Messenger getDisplayName() {
        return new DefaultedMessenger(this.lang("name"), new StaticMessenger(this.name));
    }

    public final @NonNull String getName() {
        return this.name;
    }

    public final @Nullable KingdomsParentCommand getParent() {
        return this.parent;
    }

    public final @Nullable Messenger getDescription() {
        return this.description;
    }
}

