/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.CommandClaimSquare;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;

public class CommandAdminCreate
extends KingdomsCommand {
    public CommandAdminCreate(KingdomsParentCommand parent) {
        super("create", parent);
    }

    public static void superCreate(Player player) {
        int name = 0;
        while (Kingdom.getKingdom(String.valueOf(name)) != null) {
            ++name;
        }
        Kingdom kingdom = new Kingdom(player.getUniqueId(), String.valueOf(name));
        CommandAdminCreate.initSuperKingdom(player, kingdom);
    }

    public static void initSuperKingdom(Player player, Kingdom kingdom) {
        Block block;
        kingdom.addResourcePoints(MathUtils.randInt(5000, 10000));
        kingdom.addBank(MathUtils.randInt(5000, 10000));
        TurretRegistry.getStyles().values().stream().map(t -> t.buildItem(kingdom)).forEach(item -> player.getInventory().addItem(new ItemStack[]{item}));
        StructureRegistry.getStyles().values().stream().filter(t -> !((StructureType)t.getType()).isNexus()).map(t -> t.buildItem(kingdom)).forEach(item -> player.getInventory().addItem(new ItemStack[]{item}));
        SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
        Pair<SimpleChunkLocation, SimpleChunkLocation> corners = CommandClaimSquare.getCenteredSquareCorners(chunk, 5);
        Map<SimpleChunkLocation.WorldlessWrapper, ClaimClipboard.ClaimProcessor> result = CommandClaimSquare.claimSquare(corners.getKey(), corners.getValue(), KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), kingdom);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        result.forEach((k, v) -> kingdom.claim(k.inWorld(player.getWorld()), kp, ClaimLandEvent.Reason.ADMIN));
        Land land = SimpleChunkLocation.of(player.getLocation()).getLand();
        CommandSetHome.setHome(kingdom, player.getLocation().add(0.0, 1.0, 0.0), kp);
        if (land != null && kingdom.isClaimed(land.getLocation()) && !LocationUtils.exceedsBuildLimit(player.getLocation()) && (block = LocationUtils.findEmptyBlock(player.getLocation().getBlock())) != null) {
            kingdom.placeOrMoveNexus(block.getLocation(), KingdomPlayer.getKingdomPlayer((OfflinePlayer)player));
        }
        XSound.play(player, KingdomsConfig.CREATION_KINGDOMS_SOUND.getString());
    }

    @Override
    public void execute(CommandContext context) {
        OfflinePlayer player;
        if (context.argEquals(0, "^")) {
            if (context.assertPlayer()) {
                return;
            }
            if (context.getKingdomPlayer().hasKingdom()) {
                context.sendError(KingdomsLang.COMMAND_CREATE_ALREADY_IN_KINGDOM, new Object[0]);
                return;
            }
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_CREATE_SUPER_CREATING, new Object[0]);
            CommandAdminCreate.superCreate(context.senderAsPlayer());
            return;
        }
        if (!context.assertArgs(2)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_CREATE_USAGE, new Object[0]);
            return;
        }
        if (context.argEquals(0, "*")) {
            player = PlayerUtils.getFirstPlayerThat(pl -> !KingdomPlayer.getKingdomPlayer(pl.getUniqueId()).hasKingdom());
            if (player == null) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_CREATE_ANY_NO_PLAYER_FOUND, new Object[0]);
            }
        } else {
            player = context.getOfflinePlayer(0);
        }
        if (player == null) {
            return;
        }
        context.var("target", player.getName());
        String name = context.arg(1);
        Kingdom renameKingdom = Kingdom.getKingdom(name);
        context.var("kingdom", name);
        if (renameKingdom != null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_CREATE_ALREADY_EXISTS, new Object[0]);
            return;
        }
        Kingdom kingdom = new Kingdom(player.getUniqueId(), name);
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_CREATE_CREATED, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.add(context.getPlayers(0), "^", "*");
        }
        if (context.isAtArg(1) && !context.arg(0).equals("^")) {
            return CommandAdminCreate.tabComplete("&2<name>");
        }
        return CommandAdminCreate.emptyTab();
    }
}

