/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminJoin
extends KingdomsCommand {
    public CommandAdminJoin(KingdomsParentCommand parent) {
        super("join", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(2)) {
            return;
        }
        String[] args = context.args;
        OfflinePlayer player = context.getOfflinePlayer(0);
        if (player == null) {
            return;
        }
        Kingdom kingdom = context.getKingdom(1);
        if (kingdom == null) {
            return;
        }
        context.getSettings().withContext(player).other(kingdom).raw("kingdom", kingdom.getName());
        if (kingdom.isMember(player)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_JOIN_ALREADY_IN_KINGDOM, new Object[0]);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
        if (kp.hasKingdom()) {
            if (kp.getRank().isKing()) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_JOIN_KING, new Object[0]);
                return;
            }
            if (args.length < 3 || !args[2].equalsIgnoreCase("confirm")) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_JOIN_IN_KINGDOM, new Object[0]);
                return;
            }
            kp.leaveKingdom(LeaveReason.ADMIN);
        }
        kp.joinKingdom(kingdom);
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_JOIN_SUCCESS, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getPlayers(args[0]);
        }
        if (args.length == 2) {
            return TabCompleteManager.getKingdoms(args[1]);
        }
        if (args.length == 3) {
            return Collections.singletonList("confirm");
        }
        return new ArrayList<String>();
    }
}

