/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.structures.NexusManager;

public class CommandAdminNexus
extends KingdomsCommand {
    public CommandAdminNexus(KingdomsParentCommand admin) {
        super("nexus", admin);
    }

    @Override
    public void execute(CommandContext context) {
        boolean notAdmin;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        String[] args = context.args;
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        if (args.length > 1 && (args[1].equals("tp") || args[1].equals("teleport"))) {
            SimpleLocation nexus = kingdom.getNexus();
            if (nexus == null) {
                KingdomsLang.COMMAND_ADMIN_NEXUS_TP_NOT_SET.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
                return;
            }
            KingdomsLang.COMMAND_ADMIN_NEXUS_TP.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            player.teleport(nexus.toBukkitLocation());
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        boolean bl = notAdmin = !kp.isAdmin();
        if (notAdmin) {
            kp.setAdmin(true);
        }
        new NexusManager(kingdom, player).openNexus();
        if (notAdmin) {
            kp.setAdmin(false);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getKingdoms(args[0]);
        }
        if (args.length == 2) {
            return Collections.singletonList("tp");
        }
        return CommandAdminNexus.emptyTab();
    }
}

