/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminRename
extends KingdomsCommand {
    public CommandAdminRename(KingdomsParentCommand parent) {
        super("rename", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (!context.assertArgs(2)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RENAME_USAGE, new Object[0]);
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        String name = context.arg(1);
        Kingdom renameKingdom = Kingdom.getKingdom(name);
        if (renameKingdom != null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RENAME_ALREADY_EXISTS, new Object[0]);
            return;
        }
        if (kingdom.rename(name, null).isCancelled()) {
            return;
        }
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_RENAME_RENAMED, "kingdom", kingdom.getName(), "name", name);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        if (context.isAtArg(1)) {
            return CommandAdminRename.tabComplete("&2<name>");
        }
        return CommandAdminRename.emptyTab();
    }
}

