/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminHologram
extends KingdomsCommand {
    public CommandAdminHologram(KingdomsParentCommand parent) {
        super("hologram", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        int removed = 0;
        Double radius = context.getDouble(0);
        if (radius == null) {
            return;
        }
        Player player = context.senderAsPlayer();
        for (Entity entity : player.getNearbyEntities(radius.doubleValue(), radius.doubleValue(), radius.doubleValue())) {
            ArmorStand armorStand;
            if (entity.getType() != EntityType.ARMOR_STAND || (armorStand = (ArmorStand)entity).isVisible() || !armorStand.isMarker()) continue;
            armorStand.remove();
            ++removed;
        }
        KingdomsLang.COMMAND_ADMIN_HOLOGRAM_REMOVED.sendMessage((CommandSender)player, "removed", removed);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return Collections.singletonList("<radius>");
        }
        return CommandAdminHologram.emptyTab();
    }
}

