/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;

public class CommandAdminPlayer
extends KingdomsCommand {
    public CommandAdminPlayer(KingdomsParentCommand parent) {
        super("player", parent);
    }

    @Override
    public void execute(CommandContext context) {
        Player player;
        if (!context.isPlayer() && context.requireArgs(1)) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        if (args.length == 0) {
            player = (Player)sender;
        } else {
            player = CommandAdminPlayer.getPlayer(sender, args[0]);
            if (player == null) {
                return;
            }
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        boolean hasKingdom = kingdom != null;
        StringBuilder claims = new StringBuilder(kp.getClaims().size() * 30);
        for (SimpleChunkLocation claim : kp.getClaims()) {
            if (claims.length() != 0) {
                claims.append(" &8| ");
            }
            claims.append("&5").append(claim.getWorld()).append("&7, &6").append(claim.getX()).append("&7, &6").append(claim.getZ());
        }
        Pair<Integer, Integer> map = kp.getMapSize();
        KingdomsLang.COMMAND_ADMIN_PLAYER_INFO.sendMessage(sender, (OfflinePlayer)player, new Object[]{"id", player.getUniqueId(), "kingdom_id", hasKingdom ? kingdom.getId() : "~", "visualizer", kp.isUsingMarkers() ? "&2Yes" : "&cNo", "admin", kp.isAdmin() ? "&2Yes" : "&cNo", "spy", kp.isSpy() ? "&2Yes" : "&cNo", "invites", kp.getInvites().size(), "auto_claim", kp.getAutoClaim() != null ? "&2Yes" : "&cNo", "auto_map", kp.isAutoMap() ? "&2Yes" : "&cNo", "map_height", map != null ? map.getKey() : 126, "map_width", map != null ? map.getValue() : 126, "claims", claims.toString(), "compressed", kp.getCompressedData()});
        if (args.length > 1 && (args[1].equalsIgnoreCase("fd") || args[1].equalsIgnoreCase("findduplicates"))) {
            CompletableFuture.runAsync(() -> CommandAdminPlayer.lambda$execute$0((OfflinePlayer)player, kp, kingdom, sender)).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getPlayers(args[0]);
        }
        if (args.length == 2) {
            return CommandAdminPlayer.tabComplete("findduplicates");
        }
        return CommandAdminPlayer.emptyTab();
    }

    private static /* synthetic */ void lambda$execute$0(OfflinePlayer player, KingdomPlayer kp, Kingdom kingdom, CommandSender sender) {
        ArrayList<Kingdom> found = new ArrayList<Kingdom>();
        Collection<Kingdom> kingdoms = KingdomsDataCenter.get().getKingdomManager().getKingdoms();
        for (Kingdom cacheKingdom : kingdoms) {
            if (!cacheKingdom.isMember(player.getUniqueId()) || kp.getKingdomId().equals(cacheKingdom.getId())) continue;
            found.add(kingdom);
        }
        if (found.isEmpty()) {
            KingdomsLang.COMMAND_ADMIN_PLAYER_NO_DUPLICATES.sendMessage(sender);
        } else {
            KingdomsLang.COMMAND_ADMIN_PLAYER_FOUND.sendMessage(sender, "name", player.getName(), "uuid", player.getUniqueId());
            for (Kingdom foundKingdom : found) {
                KingdomsLang.COMMAND_ADMIN_PLAYER_KINGDOM.sendMessage(sender, new MessageBuilder().withContext(foundKingdom).raw("uuid", foundKingdom.getId()));
            }
        }
    }
}

