/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.CommandClaim;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.utils.string.StringUtils;

public class CommandClaimClipboard
extends KingdomsCommand {
    public CommandClaimClipboard(KingdomsParentCommand parent) {
        super("clipboard", parent);
    }

    @Override
    public void execute(CommandContext context) {
        Action action;
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        ClaimClipboard session = ClaimClipboard.getClipboards().get(player.getUniqueId());
        if (session == null) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_EMPTY, new Object[0]);
            return;
        }
        if (!session.getWorld().getUID().equals(player.getWorld().getUID())) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_DIFFERENT_WORLD, "world", player.getWorld().getName());
            return;
        }
        if (context.assertArgs(1)) {
            try {
                action = Action.valueOf(context.arg(0).toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ex) {
                context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_UNKNOWN_ACTION, "action", context.arg(0));
                return;
            }
        } else {
            action = null;
        }
        if (action != null && action != Action.CLEAR && !context.assertArgs(3)) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_USAGE, new Object[0]);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = Objects.requireNonNull(kp.getKingdom(), () -> "Player without a kingdom has a clipboard: " + player.getName());
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            StandardKingdomPermission.CLAIM.sendDeniedMessage(player);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)context.getPlugin(), () -> {
            kp.buildMap().clipboardMode().display();
            Pair<Long, Double> costs = session.getTotalCost();
            context.sendMessage(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_COST, "rp", StringUtils.toFancyNumber(costs.getKey().longValue()), "money", StringUtils.toFancyNumber(costs.getValue()));
        });
        if (action == null) {
            return;
        }
        if (action == Action.CLEAR) {
            ClaimClipboard.getClipboards().remove(player.getUniqueId());
            KingdomsLang.COMMAND_CLAIM_CLIPBOARD_CLEARED.sendMessage((CommandSender)player);
            return;
        }
        SimpleChunkLocation.WorldlessWrapper coords = CommandClaim.getChunkCoords((CommandSender)player, context.arg(1), context.arg(2));
        if (coords == null) {
            return;
        }
        SimpleChunkLocation chunk = coords.inWorld(session.getWorld());
        context.var("x", coords.getX()).var("z", coords.getZ());
        switch (action) {
            case ADD: {
                if (session.getClaims().containsKey(chunk.worldlessWrapper())) {
                    context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_ALREADY_ADDED, new Object[0]);
                    break;
                }
                ClaimProcessor result = new ClaimProcessor(chunk, kp, kingdom).process();
                if (result.isSuccessful()) {
                    context.sendMessage(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_ADDED, new Object[0]);
                    break;
                }
                result.getIssue().sendError((CommandSender)player, result.getContextHolder());
                break;
            }
            case REMOVE: {
                if (session.getClaims().remove(coords) != null) {
                    context.sendMessage(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_REMOVED, new Object[0]);
                    break;
                }
                context.sendError(KingdomsLang.COMMAND_CLAIM_CLIPBOARD_NOT_FOUMD, new Object[0]);
            }
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return CommandClaimClipboard.tabComplete("add", "remove", "clear");
        }
        if (args.length > 1 && !args[0].equalsIgnoreCase("clear")) {
            if (args.length == 2 && !args[0].equalsIgnoreCase("clear")) {
                return CommandClaimClipboard.tabComplete("&2<x> <z>");
            }
            if (args.length == 3 && !args[0].equalsIgnoreCase("clear")) {
                return CommandClaimClipboard.tabComplete("&2<z>");
            }
        }
        return CommandClaimClipboard.emptyTab();
    }

    private static enum Action {
        ADD,
        REMOVE,
        CLEAR;

    }
}

