/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.utils.Compass;

public class CommandClaimLine
extends KingdomsCommand {
    public CommandClaimLine(KingdomsParentCommand parent) {
        super("line", parent);
    }

    public static <T> Map<SimpleChunkLocation.WorldlessWrapper, T> claimLine(SimpleChunkLocation chunk, Compass direction, int distance, Function<SimpleChunkLocation, T> transformer) {
        HashMap<SimpleChunkLocation.WorldlessWrapper, T> claims = new HashMap<SimpleChunkLocation.WorldlessWrapper, T>(distance);
        BlockFace facing = direction.toBlockFace();
        for (int i = 0; i <= distance; ++i) {
            chunk = chunk.getRelative(facing.getModX(), facing.getModZ());
            claims.put(chunk.worldlessWrapper(), transformer.apply(chunk));
        }
        return claims;
    }

    @Override
    public CommandResult executeX(CommandContext context) {
        return CommandClaimLine.commons(context, true);
    }

    public static CommandResult commons(CommandContext context, boolean claiming) {
        Compass facing;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (!context.isNumber(0)) {
            context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(0));
            return CommandResult.FAILED;
        }
        int maxDistance = KingdomsConfig.Claims.LINE_MAX_DISTANCE.getManager().getInt();
        int distance = context.intArg(0);
        if (distance < 2) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_LINE_MIN_DISTANCE, "min", 2, "distance", distance);
            return CommandResult.FAILED;
        }
        if (distance > maxDistance) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_LINE_MAX_DISTANCE, "max", maxDistance, "distance", distance);
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (context.assertArgs(1)) {
            String direction = context.joinArgs("_");
            Optional<Compass> found = Compass.getCardinalDirection(kp, direction.toLowerCase());
            if (!found.isPresent()) {
                context.sendError(KingdomsLang.COMMAND_CLAIM_LINE_INVALID_DIRECTION, "direction", direction);
                return CommandResult.FAILED;
            }
            facing = found.get();
        } else {
            facing = Compass.getCardinalDirection((Entity)player);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            Map<SimpleChunkLocation.WorldlessWrapper, AbstractClaimProcessor> claims = CommandClaimLine.claimLine(SimpleChunkLocation.of(player.getLocation()), facing, distance, chunk -> claiming ? new ClaimClipboard.ClaimProcessor((SimpleChunkLocation)chunk, kp, kingdom) : new UnclaimProcessor((SimpleChunkLocation)chunk, kp, kingdom, true));
            ClaimClipboard.addClipboard(player, claims);
            kp.buildMap().clipboardMode().display();
            context.var("direction", facing.getLanguage().getProvider(kp.getLanguage()).getMessage());
            context.var("lands", claims.size());
            context.sendMessage(claiming ? KingdomsLang.COMMAND_CLAIM_LINE_DONE : KingdomsLang.COMMAND_UNCLAIM_LINE_DONE, new Object[0]);
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandClaimLine.tabComplete("<distance>");
        }
        if (context.isAtArg(1)) {
            List<String> directions = Arrays.stream(Compass.CARDINAL_DIRECTIONS).map(x -> x.getLanguage().parse(context.getSender(), new Object[0])).collect(Collectors.toList());
            return context.suggest(1, directions);
        }
        return CommandClaimLine.emptyTab();
    }
}

