/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.commands.general.claims.CommandClaim;
import org.kingdoms.commands.general.claims.CommandUnclaimAll;
import org.kingdoms.commands.general.claims.CommandUnclaimAuto;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandUnclaim
extends KingdomsParentCommand {
    public CommandUnclaim() {
        super("unclaim", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandUnclaimAuto(this);
        new CommandUnclaimAll(this);
    }

    @Override
    public void execute(CommandContext context) {
        Kingdom kingdom;
        UnclaimProcessor processor;
        SimpleChunkLocation loc;
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        if (context.assertArgs(2)) {
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_UNCLAIM_CHUNK, true)) {
                KingdomsLang.COMMAND_CLAIM_CHUNK_PERMISSION.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (!context.isNumber(0)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(0));
                return;
            }
            if (!context.isNumber(1)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(1));
                return;
            }
            SimpleChunkLocation.WorldlessWrapper coords = CommandClaim.getChunkCoords((CommandSender)player, context.arg(0), context.arg(1));
            if (coords == null) {
                return;
            }
            loc = coords.inWorld(player.getWorld());
        } else {
            loc = SimpleChunkLocation.of(player.getLocation());
        }
        boolean confirmed = false;
        if (context.argsLengthEquals(1) || context.assertArgs(3)) {
            confirmed = context.argsLengthEquals(1) ? context.arg(0).equalsIgnoreCase("confirm") : context.arg(2).equalsIgnoreCase("confirm");
        }
        if (!(processor = new UnclaimProcessor(loc, kp, kingdom = kp.getKingdom(), confirmed).process()).isSuccessful()) {
            processor.sendIssue(context.getSender());
            return;
        }
        Land land = loc.getLand();
        if (land.unclaim(kp, UnclaimLandEvent.Reason.UNCLAIMED).isCancelled()) {
            return;
        }
        processor.finalizeRequest();
        new LandVisualizer().forPlayer(player, kp).forLand(land, loc.toChunk()).displayMessages().displayIndicators();
        KingdomsLang.COMMAND_UNCLAIM_SUCCESS.sendMessage((CommandSender)player, "x", loc.getX(), "z", loc.getZ());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            List<String> cmds = TabCompleteManager.getSubCommand(context.getSender(), this, context.getArgs());
            cmds.add("confirm");
            if (context.hasPermission(KingdomsPluginPermission.COMMAND_CLAIM_CHUNK) && cmds.isEmpty() && context.isNumber(0)) {
                cmds.addAll(CommandUnclaim.tabComplete("&2<x>"));
            }
            return cmds;
        }
        if (context.isAtArg(1) && !context.arg(0).equals("confirm")) {
            return CommandUnclaim.tabComplete("&2<z>");
        }
        if (context.isAtArg(2)) {
            return CommandUnclaim.tabComplete("confirm");
        }
        return CommandUnclaim.emptyTab();
    }
}

