/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.locale.KingdomsLang;

public class CommandUndo
extends KingdomsCommand {
    public CommandUndo() {
        super("undo", true);
    }

    protected static void landHistoryCommons(CommandContext context, boolean undo) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        Pair<Set<SimpleChunkLocation>, Boolean> history = kp.claimingHistory(undo);
        if (history == null) {
            context.sendError(undo ? KingdomsLang.COMMAND_UNDO_NO_HISTORY : KingdomsLang.COMMAND_REDO_NO_HISTORY, new Object[0]);
            return;
        }
        boolean wasClaimed = history.getValue();
        HashSet<SimpleChunkLocation> finalLands = new HashSet<SimpleChunkLocation>(history.getKey().size());
        for (SimpleChunkLocation loc : history.getKey()) {
            Land land = Land.getLand(loc);
            boolean isClaimed = land != null && land.isClaimed();
            context.var("x", loc.getX()).var("z", loc.getZ());
            if (isClaimed) {
                context.var("claimer", Bukkit.getOfflinePlayer((UUID)land.getClaimedBy()).getName());
            }
            if (undo) {
                if (wasClaimed) {
                    if (isClaimed) {
                        if (player.getUniqueId().equals(land.getClaimedBy())) {
                            finalLands.add(loc);
                            if (land.unclaim(kp, UnclaimLandEvent.Reason.CLIPBOARD, false).isCancelled()) {
                                return;
                            }
                            context.sendMessage(KingdomsLang.COMMAND_UNDO_UNCLAIMED, new Object[0]);
                            continue;
                        }
                        context.sendError(KingdomsLang.COMMAND_UNDO_CLAIMED_NOT_OWNED, new Object[0]);
                        continue;
                    }
                    context.sendError(KingdomsLang.COMMAND_UNDO_ALREADY_UNCLAIMED, new Object[0]);
                    continue;
                }
                if (isClaimed) {
                    context.sendError(KingdomsLang.COMMAND_UNDO_ALREADY_CLAIMED, new Object[0]);
                    continue;
                }
                if (kingdom.claim(Collections.singleton(loc), kp, ClaimLandEvent.Reason.CLIPBOARD, false).isCancelled()) {
                    return;
                }
                context.sendMessage(KingdomsLang.COMMAND_UNDO_CLAIMED, new Object[0]);
                continue;
            }
            if (wasClaimed) {
                if (isClaimed) {
                    context.sendError(KingdomsLang.COMMAND_REDO_ALREADY_CLAIMED, new Object[0]);
                    continue;
                }
                finalLands.add(loc);
                context.sendMessage(KingdomsLang.COMMAND_UNDO_CLAIMED, new Object[0]);
                continue;
            }
            if (isClaimed) {
                if (land.unclaim(kp, UnclaimLandEvent.Reason.CLIPBOARD, false).isCancelled()) {
                    return;
                }
                context.sendMessage(KingdomsLang.COMMAND_UNDO_UNCLAIMED, new Object[0]);
                continue;
            }
            context.sendError(KingdomsLang.COMMAND_REDO_ALREADY_UNCLAIMED, new Object[0]);
        }
        if (undo) {
            kingdom.unclaim(finalLands, kp, UnclaimLandEvent.Reason.CLIPBOARD, false);
        } else {
            kingdom.claim(finalLands, kp, ClaimLandEvent.Reason.CLIPBOARD, false);
        }
    }

    @Override
    public void execute(CommandContext context) {
        CommandUndo.landHistoryCommons(context, true);
    }
}

