/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.home;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupHomeTeleportEvent;
import org.kingdoms.events.general.KingdomSetHomeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.teleportation.IsolatedTpManager;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;

public class CommandHome
extends KingdomsCommand
implements Listener {
    private static final IsolatedTpManager TELEPORTS = new IsolatedTpManager();

    public CommandHome() {
        super("home", true);
    }

    public static Location callEvent(Group group, Player player, Location location, GroupHomeTeleportEvent.LocationType locationType) {
        GroupHomeTeleportEvent event = new GroupHomeTeleportEvent(group, player, location, locationType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled() ? null : event.getLocation();
    }

    @Override
    public CommandResult executeX(CommandContext context) {
        BukkitTask task;
        int timer;
        Location home;
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        final Player player = context.senderAsPlayer();
        if (TpManager.alreadyTping(player)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        GroupHomeTeleportEvent.LocationType locType = GroupHomeTeleportEvent.LocationType.HOME;
        if (!context.assertArgs(1)) {
            if (context.assertHasKingdom()) {
                return CommandResult.FAILED;
            }
            if (!kp.hasPermission(StandardKingdomPermission.HOME)) {
                StandardKingdomPermission.HOME.sendDeniedMessage(player);
                return CommandResult.FAILED;
            }
            kingdom = kp.getKingdom();
            home = kingdom.getHome();
            if (home == null) {
                Structure structure;
                SimpleChunkLocation chunk;
                Land nexusLand;
                if (KingdomsConfig.HOME_USE_NEXUS_IF_NOT_SET.getBoolean() && kingdom.getNexus() != null && (nexusLand = (chunk = kingdom.getNexus().toSimpleChunkLocation()).getLand()) != null && (structure = nexusLand.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus())) != null) {
                    home = LocationUtils.getSafeLocation(structure.getLocation().toBukkitLocation().add(0.5, 0.0, 0.5));
                    locType = GroupHomeTeleportEvent.LocationType.NEXUS;
                }
                if (home == null) {
                    context.sendError(KingdomsLang.COMMAND_HOME_NOT_SET, new Object[0]);
                    return CommandResult.FAILED;
                }
            }
        } else {
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_HOME_OTHERS, true)) {
                context.sendError(KingdomsLang.COMMAND_HOME_PERMISSION, new Object[0]);
                return CommandResult.FAILED;
            }
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
            home = kingdom.getHome();
            if (home == null) {
                context.sendError(KingdomsLang.COMMAND_HOME_NOT_SET_OTHERS, "kingdom", kingdom.getName());
                return CommandResult.FAILED;
            }
            if (!kp.isAdmin() && !kingdom.isMember((OfflinePlayer)player)) {
                if (!kingdom.isHomePublic()) {
                    context.sendError(KingdomsLang.COMMAND_HOME_NOT_PUBLIC, "kingdom", kingdom.getName());
                    return CommandResult.FAILED;
                }
                if (!kingdom.hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.HOME)) {
                    context.sendError(KingdomsLang.COMMAND_HOME_CANT_USE_PUBLIC_HOME, "kingdom", kingdom.getName());
                    return CommandResult.FAILED;
                }
                if (Land.getLand(kingdom.getHome()).isBeingInvaded()) {
                    context.sendError(KingdomsLang.COMMAND_HOME_BEING_INVADED, "kingdom", kingdom.getName());
                    return CommandResult.FAILED;
                }
            }
        }
        if ((timer = KingdomsConfig.HOME_TELEPORT_DELAY.getInt()) <= 0 || kp.isAdmin() || context.hasPermission(KingdomsPluginPermission.COMMAND_HOME_BYPASS_TIMER) || PlayerUtils.invulnerableGameMode(player)) {
            if ((home = CommandHome.callEvent(kingdom, player, home, locType)) == null) {
                return CommandResult.FAILED;
            }
            player.teleport(home);
            context.sendMessage(KingdomsLang.COMMAND_HOME_SUCCESS, new Object[0]);
            return CommandResult.SUCCESS;
        }
        final Location finalHome = home;
        final GroupHomeTeleportEvent.LocationType finalLocType = locType;
        if (KingdomsConfig.HOME_USE_TIMER_MESSAGE.getBoolean()) {
            task = new BukkitRunnable(){
                int timed;
                {
                    this.timed = timer;
                }

                public void run() {
                    if (this.timed <= 0) {
                        Location finalFinalHome = CommandHome.callEvent(kingdom, player, finalHome, finalLocType);
                        if (finalFinalHome != null) {
                            player.teleport(finalFinalHome);
                            KingdomsLang.COMMAND_HOME_SUCCESS.sendMessage((CommandSender)player);
                        }
                        TELEPORTS.end((Entity)player);
                        this.cancel();
                    } else {
                        KingdomsLang.COMMAND_HOME_TELEPORTING.sendMessage((CommandSender)player, "countdown", this.timed);
                        --this.timed;
                    }
                }
            }.runTaskTimer((Plugin)plugin, 0L, 20L);
        } else {
            KingdomsLang.COMMAND_HOME_TELEPORTING.sendMessage((CommandSender)player, "countdown", timer);
            task = new BukkitRunnable(){

                public void run() {
                    Location finalFinalHome = CommandHome.callEvent(kingdom, player, finalHome, finalLocType);
                    if (finalFinalHome != null) {
                        player.teleport(finalHome);
                        KingdomsLang.COMMAND_HOME_SUCCESS.sendMessage((CommandSender)player);
                    }
                    TELEPORTS.end((Entity)player);
                }
            }.runTaskLater((Plugin)plugin, (long)timer * 20L);
        }
        TeleportTask tpTask = new TeleportTask(player, task);
        tpTask.onAnyMove(event -> {
            KingdomsLang.TELEPORTS_MOVED.sendError((CommandSender)player, new Object[0]);
            return true;
        });
        TELEPORTS.put(tpTask);
        return CommandResult.SUCCESS;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHomeSet(KingdomSetHomeEvent event) {
        ArrayList<Player> putAnEnd = new ArrayList<Player>();
        for (TeleportTask task : TELEPORTS.getTasks()) {
            if (!event.getKingdom().isMember((OfflinePlayer)task.player)) continue;
            KingdomsLang.COMMAND_HOME_CHANGED.sendError((CommandSender)task.player, new Object[0]);
            putAnEnd.add(task.player);
        }
        putAnEnd.forEach(TELEPORTS::end);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsPluginPermission.COMMAND_HOME_OTHERS, true)) {
            return context.getKingdoms(0);
        }
        return CommandHome.emptyTab();
    }
}

