/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;

public class CommandAccept
extends KingdomsCommand {
    public CommandAccept() {
        super("accept", true);
    }

    @Override
    public void execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            KingdomsLang.COMMAND_ACCEPT_ALREADY_IN_KINGDOM.sendError((CommandSender)player, new Object[0]);
            return;
        }
        Map<UUID, KingdomInvite> invites = kp.getInvites();
        if (invites.isEmpty()) {
            KingdomsLang.COMMAND_ACCEPT_NO_INVITES.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!context.assertArgs(1)) {
            if (invites.size() != 1) {
                KingdomsLang.COMMAND_ACCEPT_MULTIPLE_INVITES.sendError((CommandSender)player, new Object[0]);
                return;
            }
            Map.Entry<UUID, KingdomInvite> inviteEntry = invites.entrySet().iterator().next();
            kingdom = Kingdom.getKingdom(inviteEntry.getKey());
        } else {
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return;
            }
        }
        CommandAccept.acceptInvite(player, kingdom);
    }

    public static void acceptInvite(Player player, Kingdom kingdom) {
        if (kingdom == null) {
            KingdomsLang.COMMAND_ACCEPT_NO_LONGER_EXISTS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        KingdomInvite invite = kp.getInvites().remove(kingdom.getId());
        if (invite == null) {
            KingdomsLang.COMMAND_ACCEPT_NOT_INVITED.sendError((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        if (!invite.canAccept()) {
            KingdomsLang.COMMAND_ACCEPT_EXPIRED.sendError((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        KingdomPlayer inviter = invite.getKingdomPlayer();
        OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
        KingdomsLang requirement = CommandAccept.checkRequirementsToJoin(player, kingdom);
        if (requirement != null) {
            requirement.sendError((CommandSender)player, new MessageBuilder().withContext(kingdom));
        }
        if (kp.joinKingdom(kingdom, event -> event.getMetadata().put(KingdomInvite.NAMESPACE, invite)).isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_ACCEPT_ACCEPTED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "kingdom", kingdom.getName());
        if (inviterPlayer.isOnline()) {
            KingdomsLang.COMMAND_ACCEPT_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName());
        }
        for (Player members : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_ACCEPT_JOINED.sendMessage((CommandSender)members, (OfflinePlayer)player, new Object[0]);
        }
    }

    public static KingdomsLang checkRequirementsToJoin(Player player, Kingdom kingdom) {
        if (kingdom.isFull()) {
            return KingdomsLang.COMMAND_ACCEPT_MAX_MEMBERS;
        }
        return null;
    }
}

