/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.daily.ElectionsManager;

public class CommandJoin
extends KingdomsCommand {
    public CommandJoin() {
        super("join", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            KingdomsLang.COMMAND_JOIN_ALREADY_IN_KINGDOM.sendMessage((CommandSender)player);
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        if (kingdom.requiresInvite()) {
            KingdomsLang.COMMAND_JOIN_REQUIRES_INVITE.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            return;
        }
        KingdomsLang requirement = CommandAccept.checkRequirementsToJoin(player, kingdom);
        if (requirement != null) {
            requirement.sendError((CommandSender)player, new MessageBuilder().withContext(kingdom));
        }
        if (KingdomsConfig.DAILY_CHECKS_ELECTIONS_DISALLOW_JOINS.getBoolean() && ElectionsManager.isAcceptingVotes()) {
            KingdomsLang.COMMAND_JOIN_ELECTIONS.sendMessage((CommandSender)player);
            return;
        }
        kp.joinKingdom(kingdom);
        for (Player members : kingdom.getOnlineMembers()) {
            context.sendMessage((CommandSender)members, KingdomsLang.COMMAND_JOIN_JOINED, new Object[0]);
        }
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player && args.length == 1) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender));
            if (kp.hasKingdom()) {
                return new ArrayList<String>();
            }
            return TabCompleteManager.getKingdoms(args[0]);
        }
        return new ArrayList<String>();
    }
}

