/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.FlyManager;

public class CommandFly
extends KingdomsCommand {
    public CommandFly() {
        super("fly", true);
    }

    @Override
    public void execute(CommandContext context) {
        Player player;
        boolean admin = false;
        if (context.assertArgs(1)) {
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_FLY_OTHERS)) {
                context.sendError(KingdomsLang.COMMAND_FLY_OTHERS_PERMISSION, new Object[0]);
                return;
            }
            player = context.getPlayer(0);
            if (player == null) {
                return;
            }
            admin = true;
        } else if (context.isPlayer()) {
            player = context.senderAsPlayer();
        } else {
            context.sendError(KingdomsLang.COMMAND_FLY_USAGE, new Object[0]);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            context.sendError(admin ? KingdomsLang.NO_KINGDOM_TARGET : KingdomsLang.NO_KINGDOM_DEFAULT, "target", player.getName());
            return;
        }
        if (!kp.isAdmin() && !admin) {
            Kingdom landKingdom;
            if (!kp.hasPermission(StandardKingdomPermission.FLY)) {
                StandardKingdomPermission.FLY.sendDeniedMessage(player);
                return;
            }
            Land land = Land.getLand(player.getLocation());
            if (!(land != null && land.isClaimed() || KingdomsConfig.KINGDOM_FLY_ALLOW_UNCLAIMED.getBoolean())) {
                KingdomsLang.COMMAND_FLY_UNCLAIMED.sendMessage((CommandSender)player);
                return;
            }
            Kingdom kingdom = kp.getKingdom();
            if (!kingdom.hasAttribute(landKingdom = land.getKingdom(), (RelationAttribute)StandardRelationAttribute.FLY)) {
                KingdomsLang.COMMAND_FLY_NOT_ALLOWED.sendMessage((CommandSender)player, "kingdom", landKingdom.getName());
                return;
            }
            int range = KingdomsConfig.KINGDOM_FLY_NEARBY_UNFRIENDLY_RANGE.getInt();
            if (range > 0) {
                for (Entity nearby : player.getNearbyEntities((double)range, (double)range, (double)range)) {
                    Player enemy;
                    KingdomPlayer enemyKp;
                    if (!(nearby instanceof Player) || (enemyKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)(enemy = (Player)nearby))).isInSneakMode() || kingdom.hasAttribute(enemyKp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) continue;
                    KingdomsLang.COMMAND_FLY_OWN_ENEMY_NEARBY.sendError((CommandSender)player, new Object[0]);
                    return;
                }
            }
        }
        if (player.getAllowFlight()) {
            player.setAllowFlight(false);
            player.setFlying(false);
            kp.setFlying(false);
            KingdomsLang.COMMAND_FLY_DISABLED.sendMessage((CommandSender)player);
        } else {
            if (KingdomsConfig.KINGDOM_FLY_CHARGES_ENABLED.getBoolean() && !kp.isAdmin() && !KingdomsPluginPermission.FLIGHT_BYPASS_CHARGES.hasPermission((CommandSender)player) && !FlyManager.handleCharges(player, kp, Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_ACTIVATION_COST.getManager(), KingdomsLang.COMMAND_FLY_CANT_AFFORD), Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_KINGDOMS_ACTIVATION_COST.getManager(), KingdomsLang.COMMAND_FLY_CANT_AFFORD_KINGDOM))) {
                return;
            }
            player.setAllowFlight(true);
            kp.setFlying(true);
            KingdomsLang.COMMAND_FLY_ENABLED.sendMessage((CommandSender)player);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsPluginPermission.COMMAND_FLY_OTHERS)) {
            return context.getPlayers(0);
        }
        return CommandFly.emptyTab();
    }
}

